/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.reference;

import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableList;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.base.reference.BaseMethodReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexBackedDexFile;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.util.FixedSizeList;
import java.util.List;

public class DexBackedMethodReference
extends BaseMethodReference {
    public final DexBackedDexFile dexFile;
    private final int methodIndex;
    private int protoIdItemOffset;

    public DexBackedMethodReference(DexBackedDexFile dexBackedDexFile, int n) {
        this.dexFile = dexBackedDexFile;
        this.methodIndex = n;
    }

    @Override
    public String getDefiningClass() {
        return (String)this.dexFile.getTypeSection().get(this.dexFile.getBuffer().readUshort(this.dexFile.getMethodSection().getOffset(this.methodIndex) + 0));
    }

    @Override
    public String getName() {
        return (String)this.dexFile.getStringSection().get(this.dexFile.getBuffer().readSmallUint(this.dexFile.getMethodSection().getOffset(this.methodIndex) + 4));
    }

    public List<String> getParameterTypes() {
        int n = this.getProtoIdItemOffset();
        int n2 = this.dexFile.getBuffer().readSmallUint(n + 8);
        if (n2 > 0) {
            final int n3 = this.dexFile.getDataBuffer().readSmallUint(n2 + 0);
            final int n4 = n2 + 4;
            return new FixedSizeList<String>(){

                @Override
                public String readItem(int n) {
                    return (String)DexBackedMethodReference.this.dexFile.getTypeSection().get(DexBackedMethodReference.this.dexFile.getDataBuffer().readUshort(n4 + 2 * n));
                }

                @Override
                public int size() {
                    return n3;
                }
            };
        }
        return ImmutableList.of();
    }

    @Override
    public String getReturnType() {
        int n = this.getProtoIdItemOffset();
        return (String)this.dexFile.getTypeSection().get(this.dexFile.getBuffer().readSmallUint(n + 4));
    }

    private int getProtoIdItemOffset() {
        if (this.protoIdItemOffset == 0) {
            this.protoIdItemOffset = this.dexFile.getProtoSection().getOffset(this.dexFile.getBuffer().readUshort(this.dexFile.getMethodSection().getOffset(this.methodIndex) + 2));
        }
        return this.protoIdItemOffset;
    }
}

