/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked;

import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexBuffer;
import com.github.tmurakami.dexopener.repackaged.org.jf.util.ExceptionWithContext;
import com.github.tmurakami.dexopener.repackaged.org.jf.util.Utf8Utils;

public class DexReader<T extends DexBuffer> {
    public final T dexBuf;
    private int offset;

    public DexReader(T t, int n) {
        this.dexBuf = t;
        this.offset = n;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int n) {
        this.offset = n;
    }

    public int readSleb128() {
        int n;
        int n2 = ((DexBuffer)this.dexBuf).baseOffset + this.offset;
        byte[] byArray = ((DexBuffer)this.dexBuf).buf;
        if ((n = byArray[n2++] & 0xFF) <= 127) {
            n = n << 25 >> 25;
        } else {
            int n3 = byArray[n2++] & 0xFF;
            n = n & 0x7F | (n3 & 0x7F) << 7;
            if (n3 <= 127) {
                n = n << 18 >> 18;
            } else {
                n3 = byArray[n2++] & 0xFF;
                n |= (n3 & 0x7F) << 14;
                if (n3 <= 127) {
                    n = n << 11 >> 11;
                } else {
                    n3 = byArray[n2++] & 0xFF;
                    n |= (n3 & 0x7F) << 21;
                    if (n3 <= 127) {
                        n = n << 4 >> 4;
                    } else {
                        if ((n3 = byArray[n2++] & 0xFF) > 127) {
                            throw new ExceptionWithContext("Invalid sleb128 integer encountered at offset 0x%x", this.offset);
                        }
                        n |= n3 << 28;
                    }
                }
            }
        }
        this.offset = n2 - ((DexBuffer)this.dexBuf).baseOffset;
        return n;
    }

    public int readSmallUleb128() {
        return this.readUleb128(false);
    }

    private int readUleb128(boolean bl) {
        int n;
        int n2 = ((DexBuffer)this.dexBuf).baseOffset + this.offset;
        byte[] byArray = ((DexBuffer)this.dexBuf).buf;
        if ((n = byArray[n2++] & 0xFF) > 127) {
            int n3 = byArray[n2++] & 0xFF;
            n = n & 0x7F | (n3 & 0x7F) << 7;
            if (n3 > 127) {
                n3 = byArray[n2++] & 0xFF;
                n |= (n3 & 0x7F) << 14;
                if (n3 > 127) {
                    n3 = byArray[n2++] & 0xFF;
                    n |= (n3 & 0x7F) << 21;
                    if (n3 > 127) {
                        if ((n3 = byArray[n2++]) < 0) {
                            throw new ExceptionWithContext("Invalid uleb128 integer encountered at offset 0x%x", this.offset);
                        }
                        if ((n3 & 0xF) > 7 && !bl) {
                            throw new ExceptionWithContext("Encountered valid uleb128 that is out of range at offset 0x%x", this.offset);
                        }
                        n |= n3 << 28;
                    }
                }
            }
        }
        this.offset = n2 - ((DexBuffer)this.dexBuf).baseOffset;
        return n;
    }

    public int readLargeUleb128() {
        return this.readUleb128(true);
    }

    public int readBigUleb128() {
        int n;
        int n2 = ((DexBuffer)this.dexBuf).baseOffset + this.offset;
        byte[] byArray = ((DexBuffer)this.dexBuf).buf;
        if ((n = byArray[n2++] & 0xFF) > 127) {
            int n3 = byArray[n2++] & 0xFF;
            n = n & 0x7F | (n3 & 0x7F) << 7;
            if (n3 > 127) {
                n3 = byArray[n2++] & 0xFF;
                n |= (n3 & 0x7F) << 14;
                if (n3 > 127) {
                    n3 = byArray[n2++] & 0xFF;
                    n |= (n3 & 0x7F) << 21;
                    if (n3 > 127) {
                        if ((n3 = byArray[n2++]) < 0) {
                            throw new ExceptionWithContext("Invalid uleb128 integer encountered at offset 0x%x", this.offset);
                        }
                        n |= n3 << 28;
                    }
                }
            }
        }
        this.offset = n2 - ((DexBuffer)this.dexBuf).baseOffset;
        return n;
    }

    public void skipUleb128() {
        byte by;
        int n = ((DexBuffer)this.dexBuf).baseOffset + this.offset;
        byte[] byArray = ((DexBuffer)this.dexBuf).buf;
        if ((by = byArray[n++]) < 0 && (by = byArray[n++]) < 0 && (by = byArray[n++]) < 0 && (by = byArray[n++]) < 0 && (by = byArray[n++]) < 0) {
            throw new ExceptionWithContext("Invalid uleb128 integer encountered at offset 0x%x", this.offset);
        }
        this.offset = n - ((DexBuffer)this.dexBuf).baseOffset;
    }

    public int peekUshort() {
        return ((DexBuffer)this.dexBuf).readUshort(this.offset);
    }

    public int peekUbyte() {
        return ((DexBuffer)this.dexBuf).readUbyte(this.offset);
    }

    public int readUbyte() {
        int n = this.offset;
        int n2 = ((DexBuffer)this.dexBuf).readUbyte(this.offset);
        this.offset = n + 1;
        return n2;
    }

    public int readByte() {
        int n = this.offset;
        int n2 = ((DexBuffer)this.dexBuf).readByte(this.offset);
        this.offset = n + 1;
        return n2;
    }

    public void skipByte() {
        ++this.offset;
    }

    public void moveRelative(int n) {
        this.offset += n;
    }

    public int readSizedInt(int n) {
        int n2;
        int n3 = ((DexBuffer)this.dexBuf).baseOffset + this.offset;
        byte[] byArray = ((DexBuffer)this.dexBuf).buf;
        switch (n) {
            case 4: {
                n2 = byArray[n3] & 0xFF | (byArray[n3 + 1] & 0xFF) << 8 | (byArray[n3 + 2] & 0xFF) << 16 | byArray[n3 + 3] << 24;
                break;
            }
            case 3: {
                n2 = byArray[n3] & 0xFF | (byArray[n3 + 1] & 0xFF) << 8 | byArray[n3 + 2] << 16;
                break;
            }
            case 2: {
                n2 = byArray[n3] & 0xFF | byArray[n3 + 1] << 8;
                break;
            }
            case 1: {
                n2 = byArray[n3];
                break;
            }
            default: {
                throw new ExceptionWithContext("Invalid size %d for sized int at offset 0x%x", n, this.offset);
            }
        }
        this.offset = n3 + n - ((DexBuffer)this.dexBuf).baseOffset;
        return n2;
    }

    public int readSizedSmallUint(int n) {
        int n2 = ((DexBuffer)this.dexBuf).baseOffset + this.offset;
        byte[] byArray = ((DexBuffer)this.dexBuf).buf;
        int n3 = 0;
        switch (n) {
            case 4: {
                byte by = byArray[n2 + 3];
                if (by < 0) {
                    throw new ExceptionWithContext("Encountered valid sized uint that is out of range at offset 0x%x", this.offset);
                }
                n3 = by << 24;
            }
            case 3: {
                n3 |= (byArray[n2 + 2] & 0xFF) << 16;
            }
            case 2: {
                n3 |= (byArray[n2 + 1] & 0xFF) << 8;
            }
            case 1: {
                break;
            }
            default: {
                throw new ExceptionWithContext("Invalid size %d for sized uint at offset 0x%x", n, this.offset);
            }
        }
        this.offset = n2 + n - ((DexBuffer)this.dexBuf).baseOffset;
        return n3 |= byArray[n2] & 0xFF;
    }

    public int readSizedRightExtendedInt(int n) {
        int n2;
        int n3 = ((DexBuffer)this.dexBuf).baseOffset + this.offset;
        byte[] byArray = ((DexBuffer)this.dexBuf).buf;
        switch (n) {
            case 4: {
                n2 = byArray[n3] & 0xFF | (byArray[n3 + 1] & 0xFF) << 8 | (byArray[n3 + 2] & 0xFF) << 16 | byArray[n3 + 3] << 24;
                break;
            }
            case 3: {
                n2 = (byArray[n3] & 0xFF) << 8 | (byArray[n3 + 1] & 0xFF) << 16 | byArray[n3 + 2] << 24;
                break;
            }
            case 2: {
                n2 = (byArray[n3] & 0xFF) << 16 | byArray[n3 + 1] << 24;
                break;
            }
            case 1: {
                n2 = byArray[n3] << 24;
                break;
            }
            default: {
                throw new ExceptionWithContext("Invalid size %d for sized, right extended int at offset 0x%x", n, this.offset);
            }
        }
        this.offset = n3 + n - ((DexBuffer)this.dexBuf).baseOffset;
        return n2;
    }

    public long readSizedRightExtendedLong(int n) {
        long l;
        int n2 = ((DexBuffer)this.dexBuf).baseOffset + this.offset;
        byte[] byArray = ((DexBuffer)this.dexBuf).buf;
        switch (n) {
            case 8: {
                l = (long)(byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8 | (byArray[n2 + 2] & 0xFF) << 16) | ((long)byArray[n2 + 3] & 0xFFL) << 24 | ((long)byArray[n2 + 4] & 0xFFL) << 32 | ((long)byArray[n2 + 5] & 0xFFL) << 40 | ((long)byArray[n2 + 6] & 0xFFL) << 48 | (long)byArray[n2 + 7] << 56;
                break;
            }
            case 7: {
                l = (long)((byArray[n2] & 0xFF) << 8 | (byArray[n2 + 1] & 0xFF) << 16) | ((long)byArray[n2 + 2] & 0xFFL) << 24 | ((long)byArray[n2 + 3] & 0xFFL) << 32 | ((long)byArray[n2 + 4] & 0xFFL) << 40 | ((long)byArray[n2 + 5] & 0xFFL) << 48 | (long)byArray[n2 + 6] << 56;
                break;
            }
            case 6: {
                l = (long)((byArray[n2] & 0xFF) << 16) | ((long)byArray[n2 + 1] & 0xFFL) << 24 | ((long)byArray[n2 + 2] & 0xFFL) << 32 | ((long)byArray[n2 + 3] & 0xFFL) << 40 | ((long)byArray[n2 + 4] & 0xFFL) << 48 | (long)byArray[n2 + 5] << 56;
                break;
            }
            case 5: {
                l = ((long)byArray[n2] & 0xFFL) << 24 | ((long)byArray[n2 + 1] & 0xFFL) << 32 | ((long)byArray[n2 + 2] & 0xFFL) << 40 | ((long)byArray[n2 + 3] & 0xFFL) << 48 | (long)byArray[n2 + 4] << 56;
                break;
            }
            case 4: {
                l = ((long)byArray[n2] & 0xFFL) << 32 | ((long)byArray[n2 + 1] & 0xFFL) << 40 | ((long)byArray[n2 + 2] & 0xFFL) << 48 | (long)byArray[n2 + 3] << 56;
                break;
            }
            case 3: {
                l = ((long)byArray[n2] & 0xFFL) << 40 | ((long)byArray[n2 + 1] & 0xFFL) << 48 | (long)byArray[n2 + 2] << 56;
                break;
            }
            case 2: {
                l = ((long)byArray[n2] & 0xFFL) << 48 | (long)byArray[n2 + 1] << 56;
                break;
            }
            case 1: {
                l = (long)byArray[n2] << 56;
                break;
            }
            default: {
                throw new ExceptionWithContext("Invalid size %d for sized, right extended long at offset 0x%x", n, this.offset);
            }
        }
        this.offset = n2 + n - ((DexBuffer)this.dexBuf).baseOffset;
        return l;
    }

    public long readSizedLong(int n) {
        long l;
        int n2 = ((DexBuffer)this.dexBuf).baseOffset + this.offset;
        byte[] byArray = ((DexBuffer)this.dexBuf).buf;
        switch (n) {
            case 8: {
                l = (long)(byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8 | (byArray[n2 + 2] & 0xFF) << 16) | ((long)byArray[n2 + 3] & 0xFFL) << 24 | ((long)byArray[n2 + 4] & 0xFFL) << 32 | ((long)byArray[n2 + 5] & 0xFFL) << 40 | ((long)byArray[n2 + 6] & 0xFFL) << 48 | (long)byArray[n2 + 7] << 56;
                break;
            }
            case 7: {
                l = (long)(byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8 | (byArray[n2 + 2] & 0xFF) << 16) | ((long)byArray[n2 + 3] & 0xFFL) << 24 | ((long)byArray[n2 + 4] & 0xFFL) << 32 | ((long)byArray[n2 + 5] & 0xFFL) << 40 | (long)byArray[n2 + 6] << 48;
                break;
            }
            case 6: {
                l = (long)(byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8 | (byArray[n2 + 2] & 0xFF) << 16) | ((long)byArray[n2 + 3] & 0xFFL) << 24 | ((long)byArray[n2 + 4] & 0xFFL) << 32 | (long)byArray[n2 + 5] << 40;
                break;
            }
            case 5: {
                l = (long)(byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8 | (byArray[n2 + 2] & 0xFF) << 16) | ((long)byArray[n2 + 3] & 0xFFL) << 24 | (long)byArray[n2 + 4] << 32;
                break;
            }
            case 4: {
                l = (long)(byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8 | (byArray[n2 + 2] & 0xFF) << 16) | (long)byArray[n2 + 3] << 24;
                break;
            }
            case 3: {
                l = byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8 | byArray[n2 + 2] << 16;
                break;
            }
            case 2: {
                l = byArray[n2] & 0xFF | byArray[n2 + 1] << 8;
                break;
            }
            case 1: {
                l = byArray[n2];
                break;
            }
            default: {
                throw new ExceptionWithContext("Invalid size %d for sized long at offset 0x%x", n, this.offset);
            }
        }
        this.offset = n2 + n - ((DexBuffer)this.dexBuf).baseOffset;
        return l;
    }

    public String readString(int n) {
        int[] nArray = new int[1];
        String string = Utf8Utils.utf8BytesWithUtf16LengthToString(((DexBuffer)this.dexBuf).buf, ((DexBuffer)this.dexBuf).baseOffset + this.offset, n, nArray);
        this.offset += nArray[0];
        return string;
    }
}

