/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder;

import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.Opcode;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.BuilderInstruction;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.Label;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.OffsetInstruction;
import com.github.tmurakami.dexopener.repackaged.org.jf.util.ExceptionWithContext;

public abstract class BuilderOffsetInstruction
extends BuilderInstruction
implements OffsetInstruction {
    protected final Label target;

    public BuilderOffsetInstruction(Opcode opcode, Label label) {
        super(opcode);
        this.target = label;
    }

    @Override
    public int getCodeOffset() {
        int n = this.internalGetCodeOffset();
        if (this.getCodeUnits() == 1) {
            if (n < -128 || n > 127) {
                throw new ExceptionWithContext("Invalid instruction offset: %d. Offset must be in [-128, 127]", n);
            }
        } else if (this.getCodeUnits() == 2 && (n < Short.MIN_VALUE || n > Short.MAX_VALUE)) {
            throw new ExceptionWithContext("Invalid instruction offset: %d. Offset must be in [-32768, 32767]", n);
        }
        return n;
    }

    int internalGetCodeOffset() {
        return this.target.getCodeAddress() - this.getLocation().getCodeAddress();
    }

    public Label getTarget() {
        return this.target;
    }
}

