/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.com.google.common.base;

import java.util.logging.Level;
import java.util.logging.Logger;

public final class Strings {
    public static String lenientFormat(String string, Object ... objectArray) {
        int n;
        string = String.valueOf(string);
        if (objectArray == null) {
            objectArray = new Object[]{"(Object[])null"};
        } else {
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = Strings.lenientToString(objectArray[i]);
            }
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + 16 * objectArray.length);
        int n2 = 0;
        int n3 = 0;
        while (n3 < objectArray.length && (n = string.indexOf("%s", n2)) != -1) {
            stringBuilder.append(string, n2, n);
            stringBuilder.append(objectArray[n3++]);
            n2 = n + 2;
        }
        stringBuilder.append(string, n2, string.length());
        if (n3 < objectArray.length) {
            stringBuilder.append(" [");
            stringBuilder.append(objectArray[n3++]);
            while (n3 < objectArray.length) {
                stringBuilder.append(", ");
                stringBuilder.append(objectArray[n3++]);
            }
            stringBuilder.append(']');
        }
        return stringBuilder.toString();
    }

    private static String lenientToString(Object object) {
        try {
            return String.valueOf(object);
        }
        catch (Exception exception) {
            String string = object.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(object));
            Logger.getLogger("com.github.tmurakami.dexopener.repackaged.com.google.common.base.Strings").log(Level.WARNING, "Exception during lenientFormat for " + string, exception);
            return "<" + string + " threw " + exception.getClass().getName() + ">";
        }
    }
}

