/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.reference;

import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.Lists;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.base.reference.BaseCallSiteReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexBackedDexFile;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.util.EncodedArrayItemIterator;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.reference.MethodHandleReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.reference.MethodProtoReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.EncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.MethodHandleEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.MethodTypeEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.StringEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.util.ExceptionWithContext;
import java.util.ArrayList;
import java.util.List;

public class DexBackedCallSiteReference
extends BaseCallSiteReference {
    public final DexBackedDexFile dexFile;
    public final int callSiteIndex;
    public final int callSiteIdOffset;
    private int callSiteOffset = -1;

    public DexBackedCallSiteReference(DexBackedDexFile dexBackedDexFile, int n) {
        this.dexFile = dexBackedDexFile;
        this.callSiteIndex = n;
        this.callSiteIdOffset = dexBackedDexFile.getCallSiteSection().getOffset(n);
    }

    @Override
    public String getName() {
        return String.format("call_site_%d", this.callSiteIndex);
    }

    @Override
    public MethodHandleReference getMethodHandle() {
        EncodedArrayItemIterator encodedArrayItemIterator = this.getCallSiteIterator();
        if (encodedArrayItemIterator.getItemCount() < 3) {
            throw new ExceptionWithContext("Invalid call site item: must contain at least 3 entries.", new Object[0]);
        }
        EncodedValue encodedValue = this.getCallSiteIterator().getNextOrNull();
        assert (encodedValue != null);
        if (encodedValue.getValueType() != 22) {
            throw new ExceptionWithContext("Invalid encoded value type (%d) for the first item in call site %d", encodedValue.getValueType(), this.callSiteIndex);
        }
        return ((MethodHandleEncodedValue)encodedValue).getValue();
    }

    @Override
    public String getMethodName() {
        EncodedArrayItemIterator encodedArrayItemIterator = this.getCallSiteIterator();
        if (encodedArrayItemIterator.getItemCount() < 3) {
            throw new ExceptionWithContext("Invalid call site item: must contain at least 3 entries.", new Object[0]);
        }
        encodedArrayItemIterator.skipNext();
        EncodedValue encodedValue = encodedArrayItemIterator.getNextOrNull();
        assert (encodedValue != null);
        if (encodedValue.getValueType() != 23) {
            throw new ExceptionWithContext("Invalid encoded value type (%d) for the second item in call site %d", encodedValue.getValueType(), this.callSiteIndex);
        }
        return ((StringEncodedValue)encodedValue).getValue();
    }

    @Override
    public MethodProtoReference getMethodProto() {
        EncodedArrayItemIterator encodedArrayItemIterator = this.getCallSiteIterator();
        if (encodedArrayItemIterator.getItemCount() < 3) {
            throw new ExceptionWithContext("Invalid call site item: must contain at least 3 entries.", new Object[0]);
        }
        encodedArrayItemIterator.skipNext();
        encodedArrayItemIterator.skipNext();
        EncodedValue encodedValue = encodedArrayItemIterator.getNextOrNull();
        assert (encodedValue != null);
        if (encodedValue.getValueType() != 21) {
            throw new ExceptionWithContext("Invalid encoded value type (%d) for the second item in call site %d", encodedValue.getValueType(), this.callSiteIndex);
        }
        return ((MethodTypeEncodedValue)encodedValue).getValue();
    }

    @Override
    public List<? extends EncodedValue> getExtraArguments() {
        ArrayList<EncodedValue> arrayList = Lists.newArrayList();
        EncodedArrayItemIterator encodedArrayItemIterator = this.getCallSiteIterator();
        if (encodedArrayItemIterator.getItemCount() < 3) {
            throw new ExceptionWithContext("Invalid call site item: must contain at least 3 entries.", new Object[0]);
        }
        if (encodedArrayItemIterator.getItemCount() == 3) {
            return arrayList;
        }
        encodedArrayItemIterator.skipNext();
        encodedArrayItemIterator.skipNext();
        encodedArrayItemIterator.skipNext();
        EncodedValue encodedValue = encodedArrayItemIterator.getNextOrNull();
        while (encodedValue != null) {
            arrayList.add(encodedValue);
            encodedValue = encodedArrayItemIterator.getNextOrNull();
        }
        return arrayList;
    }

    private EncodedArrayItemIterator getCallSiteIterator() {
        return EncodedArrayItemIterator.newOrEmpty(this.dexFile, this.getCallSiteOffset());
    }

    private int getCallSiteOffset() {
        if (this.callSiteOffset < 0) {
            this.callSiteOffset = this.dexFile.getBuffer().readSmallUint(this.callSiteIdOffset);
        }
        return this.callSiteOffset;
    }
}

