/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.instruction;

import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.Opcode;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexBackedDexFile;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.instruction.DexBackedInstruction;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.util.FixedSizeList;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.ArrayPayload;
import com.github.tmurakami.dexopener.repackaged.org.jf.util.ExceptionWithContext;
import java.util.List;

public class DexBackedArrayPayload
extends DexBackedInstruction
implements ArrayPayload {
    public static final Opcode OPCODE = Opcode.ARRAY_PAYLOAD;
    public final int elementWidth;
    public final int elementCount;

    public DexBackedArrayPayload(DexBackedDexFile dexBackedDexFile, int n) {
        super(dexBackedDexFile, OPCODE, n);
        this.elementWidth = dexBackedDexFile.getDataBuffer().readUshort(n + 2);
        this.elementCount = dexBackedDexFile.getDataBuffer().readSmallUint(n + 4);
        if ((long)this.elementWidth * (long)this.elementCount > Integer.MAX_VALUE) {
            throw new ExceptionWithContext("Invalid array-payload instruction: element width*count overflows", new Object[0]);
        }
    }

    @Override
    public int getElementWidth() {
        return this.elementWidth;
    }

    @Override
    public List<Number> getArrayElements() {
        final int n = this.instructionStart + 8;
        switch (this.elementWidth) {
            abstract class ReturnedList
            extends FixedSizeList<Number> {
                ReturnedList() {
                }

                @Override
                public int size() {
                    return DexBackedArrayPayload.this.elementCount;
                }
            }
            case 1: {
                return new ReturnedList(){
                    {
                    }

                    @Override
                    public Number readItem(int n2) {
                        return DexBackedArrayPayload.this.dexFile.getDataBuffer().readByte(n + n2);
                    }
                };
            }
            case 2: {
                return new ReturnedList(){
                    {
                    }

                    @Override
                    public Number readItem(int n2) {
                        return DexBackedArrayPayload.this.dexFile.getDataBuffer().readShort(n + n2 * 2);
                    }
                };
            }
            case 4: {
                return new ReturnedList(){
                    {
                    }

                    @Override
                    public Number readItem(int n2) {
                        return DexBackedArrayPayload.this.dexFile.getDataBuffer().readInt(n + n2 * 4);
                    }
                };
            }
            case 8: {
                return new ReturnedList(){
                    {
                    }

                    @Override
                    public Number readItem(int n2) {
                        return DexBackedArrayPayload.this.dexFile.getDataBuffer().readLong(n + n2 * 8);
                    }
                };
            }
        }
        throw new ExceptionWithContext("Invalid element width: %d", this.elementWidth);
    }

    @Override
    public int getCodeUnits() {
        return 4 + (this.elementWidth * this.elementCount + 1) / 2;
    }
}

