/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2;

import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableRangeMap;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.Lists;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.Range;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.RangeMap;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.Format;
import java.util.ArrayList;
import java.util.List;

public final class Opcode
extends Enum<Opcode> {
    public static final /* enum */ Opcode NOP = new Opcode(0, "nop", 7, Format.Format10x, 4);
    public static final /* enum */ Opcode MOVE = new Opcode(1, "move", 7, Format.Format12x, 20);
    public static final /* enum */ Opcode MOVE_FROM16 = new Opcode(2, "move/from16", 7, Format.Format22x, 20);
    public static final /* enum */ Opcode MOVE_16 = new Opcode(3, "move/16", 7, Format.Format32x, 20);
    public static final /* enum */ Opcode MOVE_WIDE = new Opcode(4, "move-wide", 7, Format.Format12x, 52);
    public static final /* enum */ Opcode MOVE_WIDE_FROM16 = new Opcode(5, "move-wide/from16", 7, Format.Format22x, 52);
    public static final /* enum */ Opcode MOVE_WIDE_16 = new Opcode(6, "move-wide/16", 7, Format.Format32x, 52);
    public static final /* enum */ Opcode MOVE_OBJECT = new Opcode(7, "move-object", 7, Format.Format12x, 20);
    public static final /* enum */ Opcode MOVE_OBJECT_FROM16 = new Opcode(8, "move-object/from16", 7, Format.Format22x, 20);
    public static final /* enum */ Opcode MOVE_OBJECT_16 = new Opcode(9, "move-object/16", 7, Format.Format32x, 20);
    public static final /* enum */ Opcode MOVE_RESULT = new Opcode(10, "move-result", 7, Format.Format11x, 20);
    public static final /* enum */ Opcode MOVE_RESULT_WIDE = new Opcode(11, "move-result-wide", 7, Format.Format11x, 52);
    public static final /* enum */ Opcode MOVE_RESULT_OBJECT = new Opcode(12, "move-result-object", 7, Format.Format11x, 20);
    public static final /* enum */ Opcode MOVE_EXCEPTION = new Opcode(13, "move-exception", 7, Format.Format11x, 20);
    public static final /* enum */ Opcode RETURN_VOID = new Opcode(14, "return-void", 7, Format.Format10x);
    public static final /* enum */ Opcode RETURN = new Opcode(15, "return", 7, Format.Format11x);
    public static final /* enum */ Opcode RETURN_WIDE = new Opcode(16, "return-wide", 7, Format.Format11x);
    public static final /* enum */ Opcode RETURN_OBJECT = new Opcode(17, "return-object", 7, Format.Format11x);
    public static final /* enum */ Opcode CONST_4 = new Opcode(18, "const/4", 7, Format.Format11n, 20);
    public static final /* enum */ Opcode CONST_16 = new Opcode(19, "const/16", 7, Format.Format21s, 20);
    public static final /* enum */ Opcode CONST = new Opcode(20, "const", 7, Format.Format31i, 20);
    public static final /* enum */ Opcode CONST_HIGH16 = new Opcode(21, "const/high16", 7, Format.Format21ih, 20);
    public static final /* enum */ Opcode CONST_WIDE_16 = new Opcode(22, "const-wide/16", 7, Format.Format21s, 52);
    public static final /* enum */ Opcode CONST_WIDE_32 = new Opcode(23, "const-wide/32", 7, Format.Format31i, 52);
    public static final /* enum */ Opcode CONST_WIDE = new Opcode(24, "const-wide", 7, Format.Format51l, 52);
    public static final /* enum */ Opcode CONST_WIDE_HIGH16 = new Opcode(25, "const-wide/high16", 7, Format.Format21lh, 52);
    public static final /* enum */ Opcode CONST_STRING = new Opcode(26, "const-string", 0, Format.Format21c, 21);
    public static final /* enum */ Opcode CONST_STRING_JUMBO = new Opcode(27, "const-string/jumbo", 0, Format.Format31c, 21);
    public static final /* enum */ Opcode CONST_CLASS = new Opcode(28, "const-class", 1, Format.Format21c, 21);
    public static final /* enum */ Opcode MONITOR_ENTER = new Opcode(29, "monitor-enter", 7, Format.Format11x, 5);
    public static final /* enum */ Opcode MONITOR_EXIT = new Opcode(30, "monitor-exit", 7, Format.Format11x, 5);
    public static final /* enum */ Opcode CHECK_CAST = new Opcode(31, "check-cast", 1, Format.Format21c, 21);
    public static final /* enum */ Opcode INSTANCE_OF = new Opcode(32, "instance-of", 1, Format.Format22c, 21);
    public static final /* enum */ Opcode ARRAY_LENGTH = new Opcode(33, "array-length", 7, Format.Format12x, 21);
    public static final /* enum */ Opcode NEW_INSTANCE = new Opcode(34, "new-instance", 1, Format.Format21c, 21);
    public static final /* enum */ Opcode NEW_ARRAY = new Opcode(35, "new-array", 1, Format.Format22c, 21);
    public static final /* enum */ Opcode FILLED_NEW_ARRAY = new Opcode(36, "filled-new-array", 1, Format.Format35c, 13);
    public static final /* enum */ Opcode FILLED_NEW_ARRAY_RANGE = new Opcode(37, "filled-new-array/range", 1, Format.Format3rc, 13);
    public static final /* enum */ Opcode FILL_ARRAY_DATA = new Opcode(38, "fill-array-data", 7, Format.Format31t, 4);
    public static final /* enum */ Opcode THROW = new Opcode(39, "throw", 7, Format.Format11x, 1);
    public static final /* enum */ Opcode GOTO = new Opcode(40, "goto", 7, Format.Format10t);
    public static final /* enum */ Opcode GOTO_16 = new Opcode(41, "goto/16", 7, Format.Format20t);
    public static final /* enum */ Opcode GOTO_32 = new Opcode(42, "goto/32", 7, Format.Format30t);
    public static final /* enum */ Opcode PACKED_SWITCH = new Opcode(43, "packed-switch", 7, Format.Format31t, 4);
    public static final /* enum */ Opcode SPARSE_SWITCH = new Opcode(44, "sparse-switch", 7, Format.Format31t, 4);
    public static final /* enum */ Opcode CMPL_FLOAT = new Opcode(45, "cmpl-float", 7, Format.Format23x, 20);
    public static final /* enum */ Opcode CMPG_FLOAT = new Opcode(46, "cmpg-float", 7, Format.Format23x, 20);
    public static final /* enum */ Opcode CMPL_DOUBLE = new Opcode(47, "cmpl-double", 7, Format.Format23x, 20);
    public static final /* enum */ Opcode CMPG_DOUBLE = new Opcode(48, "cmpg-double", 7, Format.Format23x, 20);
    public static final /* enum */ Opcode CMP_LONG = new Opcode(49, "cmp-long", 7, Format.Format23x, 20);
    public static final /* enum */ Opcode IF_EQ = new Opcode(50, "if-eq", 7, Format.Format22t, 4);
    public static final /* enum */ Opcode IF_NE = new Opcode(51, "if-ne", 7, Format.Format22t, 4);
    public static final /* enum */ Opcode IF_LT = new Opcode(52, "if-lt", 7, Format.Format22t, 4);
    public static final /* enum */ Opcode IF_GE = new Opcode(53, "if-ge", 7, Format.Format22t, 4);
    public static final /* enum */ Opcode IF_GT = new Opcode(54, "if-gt", 7, Format.Format22t, 4);
    public static final /* enum */ Opcode IF_LE = new Opcode(55, "if-le", 7, Format.Format22t, 4);
    public static final /* enum */ Opcode IF_EQZ = new Opcode(56, "if-eqz", 7, Format.Format21t, 4);
    public static final /* enum */ Opcode IF_NEZ = new Opcode(57, "if-nez", 7, Format.Format21t, 4);
    public static final /* enum */ Opcode IF_LTZ = new Opcode(58, "if-ltz", 7, Format.Format21t, 4);
    public static final /* enum */ Opcode IF_GEZ = new Opcode(59, "if-gez", 7, Format.Format21t, 4);
    public static final /* enum */ Opcode IF_GTZ = new Opcode(60, "if-gtz", 7, Format.Format21t, 4);
    public static final /* enum */ Opcode IF_LEZ = new Opcode(61, "if-lez", 7, Format.Format21t, 4);
    public static final /* enum */ Opcode AGET = new Opcode(68, "aget", 7, Format.Format23x, 21);
    public static final /* enum */ Opcode AGET_WIDE = new Opcode(69, "aget-wide", 7, Format.Format23x, 53);
    public static final /* enum */ Opcode AGET_OBJECT = new Opcode(70, "aget-object", 7, Format.Format23x, 21);
    public static final /* enum */ Opcode AGET_BOOLEAN = new Opcode(71, "aget-boolean", 7, Format.Format23x, 21);
    public static final /* enum */ Opcode AGET_BYTE = new Opcode(72, "aget-byte", 7, Format.Format23x, 21);
    public static final /* enum */ Opcode AGET_CHAR = new Opcode(73, "aget-char", 7, Format.Format23x, 21);
    public static final /* enum */ Opcode AGET_SHORT = new Opcode(74, "aget-short", 7, Format.Format23x, 21);
    public static final /* enum */ Opcode APUT = new Opcode(75, "aput", 7, Format.Format23x, 5);
    public static final /* enum */ Opcode APUT_WIDE = new Opcode(76, "aput-wide", 7, Format.Format23x, 5);
    public static final /* enum */ Opcode APUT_OBJECT = new Opcode(77, "aput-object", 7, Format.Format23x, 5);
    public static final /* enum */ Opcode APUT_BOOLEAN = new Opcode(78, "aput-boolean", 7, Format.Format23x, 5);
    public static final /* enum */ Opcode APUT_BYTE = new Opcode(79, "aput-byte", 7, Format.Format23x, 5);
    public static final /* enum */ Opcode APUT_CHAR = new Opcode(80, "aput-char", 7, Format.Format23x, 5);
    public static final /* enum */ Opcode APUT_SHORT = new Opcode(81, "aput-short", 7, Format.Format23x, 5);
    public static final /* enum */ Opcode IGET = new Opcode(82, "iget", 2, Format.Format22c, 21);
    public static final /* enum */ Opcode IGET_WIDE = new Opcode(83, "iget-wide", 2, Format.Format22c, 53);
    public static final /* enum */ Opcode IGET_OBJECT = new Opcode(84, "iget-object", 2, Format.Format22c, 21);
    public static final /* enum */ Opcode IGET_BOOLEAN = new Opcode(85, "iget-boolean", 2, Format.Format22c, 21);
    public static final /* enum */ Opcode IGET_BYTE = new Opcode(86, "iget-byte", 2, Format.Format22c, 21);
    public static final /* enum */ Opcode IGET_CHAR = new Opcode(87, "iget-char", 2, Format.Format22c, 21);
    public static final /* enum */ Opcode IGET_SHORT = new Opcode(88, "iget-short", 2, Format.Format22c, 21);
    public static final /* enum */ Opcode IPUT = new Opcode(89, "iput", 2, Format.Format22c, 5);
    public static final /* enum */ Opcode IPUT_WIDE = new Opcode(90, "iput-wide", 2, Format.Format22c, 5);
    public static final /* enum */ Opcode IPUT_OBJECT = new Opcode(91, "iput-object", 2, Format.Format22c, 5);
    public static final /* enum */ Opcode IPUT_BOOLEAN = new Opcode(92, "iput-boolean", 2, Format.Format22c, 5);
    public static final /* enum */ Opcode IPUT_BYTE = new Opcode(93, "iput-byte", 2, Format.Format22c, 5);
    public static final /* enum */ Opcode IPUT_CHAR = new Opcode(94, "iput-char", 2, Format.Format22c, 5);
    public static final /* enum */ Opcode IPUT_SHORT = new Opcode(95, "iput-short", 2, Format.Format22c, 5);
    public static final /* enum */ Opcode SGET = new Opcode(96, "sget", 2, Format.Format21c, 277);
    public static final /* enum */ Opcode SGET_WIDE = new Opcode(97, "sget-wide", 2, Format.Format21c, 309);
    public static final /* enum */ Opcode SGET_OBJECT = new Opcode(98, "sget-object", 2, Format.Format21c, 277);
    public static final /* enum */ Opcode SGET_BOOLEAN = new Opcode(99, "sget-boolean", 2, Format.Format21c, 277);
    public static final /* enum */ Opcode SGET_BYTE = new Opcode(100, "sget-byte", 2, Format.Format21c, 277);
    public static final /* enum */ Opcode SGET_CHAR = new Opcode(101, "sget-char", 2, Format.Format21c, 277);
    public static final /* enum */ Opcode SGET_SHORT = new Opcode(102, "sget-short", 2, Format.Format21c, 277);
    public static final /* enum */ Opcode SPUT = new Opcode(103, "sput", 2, Format.Format21c, 261);
    public static final /* enum */ Opcode SPUT_WIDE = new Opcode(104, "sput-wide", 2, Format.Format21c, 261);
    public static final /* enum */ Opcode SPUT_OBJECT = new Opcode(105, "sput-object", 2, Format.Format21c, 261);
    public static final /* enum */ Opcode SPUT_BOOLEAN = new Opcode(106, "sput-boolean", 2, Format.Format21c, 261);
    public static final /* enum */ Opcode SPUT_BYTE = new Opcode(107, "sput-byte", 2, Format.Format21c, 261);
    public static final /* enum */ Opcode SPUT_CHAR = new Opcode(108, "sput-char", 2, Format.Format21c, 261);
    public static final /* enum */ Opcode SPUT_SHORT = new Opcode(109, "sput-short", 2, Format.Format21c, 261);
    public static final /* enum */ Opcode INVOKE_VIRTUAL = new Opcode(110, "invoke-virtual", 3, Format.Format35c, 13);
    public static final /* enum */ Opcode INVOKE_SUPER = new Opcode(111, "invoke-super", 3, Format.Format35c, 13);
    public static final /* enum */ Opcode INVOKE_DIRECT = new Opcode(112, "invoke-direct", 3, Format.Format35c, 1037);
    public static final /* enum */ Opcode INVOKE_STATIC = new Opcode(113, "invoke-static", 3, Format.Format35c, 13);
    public static final /* enum */ Opcode INVOKE_INTERFACE = new Opcode(114, "invoke-interface", 3, Format.Format35c, 13);
    public static final /* enum */ Opcode INVOKE_VIRTUAL_RANGE = new Opcode(116, "invoke-virtual/range", 3, Format.Format3rc, 13);
    public static final /* enum */ Opcode INVOKE_SUPER_RANGE = new Opcode(117, "invoke-super/range", 3, Format.Format3rc, 13);
    public static final /* enum */ Opcode INVOKE_DIRECT_RANGE = new Opcode(118, "invoke-direct/range", 3, Format.Format3rc, 1037);
    public static final /* enum */ Opcode INVOKE_STATIC_RANGE = new Opcode(119, "invoke-static/range", 3, Format.Format3rc, 13);
    public static final /* enum */ Opcode INVOKE_INTERFACE_RANGE = new Opcode(120, "invoke-interface/range", 3, Format.Format3rc, 13);
    public static final /* enum */ Opcode NEG_INT = new Opcode(123, "neg-int", 7, Format.Format12x, 20);
    public static final /* enum */ Opcode NOT_INT = new Opcode(124, "not-int", 7, Format.Format12x, 20);
    public static final /* enum */ Opcode NEG_LONG = new Opcode(125, "neg-long", 7, Format.Format12x, 52);
    public static final /* enum */ Opcode NOT_LONG = new Opcode(126, "not-long", 7, Format.Format12x, 52);
    public static final /* enum */ Opcode NEG_FLOAT = new Opcode(127, "neg-float", 7, Format.Format12x, 20);
    public static final /* enum */ Opcode NEG_DOUBLE = new Opcode(128, "neg-double", 7, Format.Format12x, 52);
    public static final /* enum */ Opcode INT_TO_LONG = new Opcode(129, "int-to-long", 7, Format.Format12x, 52);
    public static final /* enum */ Opcode INT_TO_FLOAT = new Opcode(130, "int-to-float", 7, Format.Format12x, 20);
    public static final /* enum */ Opcode INT_TO_DOUBLE = new Opcode(131, "int-to-double", 7, Format.Format12x, 52);
    public static final /* enum */ Opcode LONG_TO_INT = new Opcode(132, "long-to-int", 7, Format.Format12x, 20);
    public static final /* enum */ Opcode LONG_TO_FLOAT = new Opcode(133, "long-to-float", 7, Format.Format12x, 20);
    public static final /* enum */ Opcode LONG_TO_DOUBLE = new Opcode(134, "long-to-double", 7, Format.Format12x, 52);
    public static final /* enum */ Opcode FLOAT_TO_INT = new Opcode(135, "float-to-int", 7, Format.Format12x, 20);
    public static final /* enum */ Opcode FLOAT_TO_LONG = new Opcode(136, "float-to-long", 7, Format.Format12x, 52);
    public static final /* enum */ Opcode FLOAT_TO_DOUBLE = new Opcode(137, "float-to-double", 7, Format.Format12x, 52);
    public static final /* enum */ Opcode DOUBLE_TO_INT = new Opcode(138, "double-to-int", 7, Format.Format12x, 20);
    public static final /* enum */ Opcode DOUBLE_TO_LONG = new Opcode(139, "double-to-long", 7, Format.Format12x, 52);
    public static final /* enum */ Opcode DOUBLE_TO_FLOAT = new Opcode(140, "double-to-float", 7, Format.Format12x, 20);
    public static final /* enum */ Opcode INT_TO_BYTE = new Opcode(141, "int-to-byte", 7, Format.Format12x, 20);
    public static final /* enum */ Opcode INT_TO_CHAR = new Opcode(142, "int-to-char", 7, Format.Format12x, 20);
    public static final /* enum */ Opcode INT_TO_SHORT = new Opcode(143, "int-to-short", 7, Format.Format12x, 20);
    public static final /* enum */ Opcode ADD_INT = new Opcode(144, "add-int", 7, Format.Format23x, 20);
    public static final /* enum */ Opcode SUB_INT = new Opcode(145, "sub-int", 7, Format.Format23x, 20);
    public static final /* enum */ Opcode MUL_INT = new Opcode(146, "mul-int", 7, Format.Format23x, 20);
    public static final /* enum */ Opcode DIV_INT = new Opcode(147, "div-int", 7, Format.Format23x, 21);
    public static final /* enum */ Opcode REM_INT = new Opcode(148, "rem-int", 7, Format.Format23x, 21);
    public static final /* enum */ Opcode AND_INT = new Opcode(149, "and-int", 7, Format.Format23x, 20);
    public static final /* enum */ Opcode OR_INT = new Opcode(150, "or-int", 7, Format.Format23x, 20);
    public static final /* enum */ Opcode XOR_INT = new Opcode(151, "xor-int", 7, Format.Format23x, 20);
    public static final /* enum */ Opcode SHL_INT = new Opcode(152, "shl-int", 7, Format.Format23x, 20);
    public static final /* enum */ Opcode SHR_INT = new Opcode(153, "shr-int", 7, Format.Format23x, 20);
    public static final /* enum */ Opcode USHR_INT = new Opcode(154, "ushr-int", 7, Format.Format23x, 20);
    public static final /* enum */ Opcode ADD_LONG = new Opcode(155, "add-long", 7, Format.Format23x, 52);
    public static final /* enum */ Opcode SUB_LONG = new Opcode(156, "sub-long", 7, Format.Format23x, 52);
    public static final /* enum */ Opcode MUL_LONG = new Opcode(157, "mul-long", 7, Format.Format23x, 52);
    public static final /* enum */ Opcode DIV_LONG = new Opcode(158, "div-long", 7, Format.Format23x, 53);
    public static final /* enum */ Opcode REM_LONG = new Opcode(159, "rem-long", 7, Format.Format23x, 53);
    public static final /* enum */ Opcode AND_LONG = new Opcode(160, "and-long", 7, Format.Format23x, 52);
    public static final /* enum */ Opcode OR_LONG = new Opcode(161, "or-long", 7, Format.Format23x, 52);
    public static final /* enum */ Opcode XOR_LONG = new Opcode(162, "xor-long", 7, Format.Format23x, 52);
    public static final /* enum */ Opcode SHL_LONG = new Opcode(163, "shl-long", 7, Format.Format23x, 52);
    public static final /* enum */ Opcode SHR_LONG = new Opcode(164, "shr-long", 7, Format.Format23x, 52);
    public static final /* enum */ Opcode USHR_LONG = new Opcode(165, "ushr-long", 7, Format.Format23x, 52);
    public static final /* enum */ Opcode ADD_FLOAT = new Opcode(166, "add-float", 7, Format.Format23x, 20);
    public static final /* enum */ Opcode SUB_FLOAT = new Opcode(167, "sub-float", 7, Format.Format23x, 20);
    public static final /* enum */ Opcode MUL_FLOAT = new Opcode(168, "mul-float", 7, Format.Format23x, 20);
    public static final /* enum */ Opcode DIV_FLOAT = new Opcode(169, "div-float", 7, Format.Format23x, 20);
    public static final /* enum */ Opcode REM_FLOAT = new Opcode(170, "rem-float", 7, Format.Format23x, 20);
    public static final /* enum */ Opcode ADD_DOUBLE = new Opcode(171, "add-double", 7, Format.Format23x, 52);
    public static final /* enum */ Opcode SUB_DOUBLE = new Opcode(172, "sub-double", 7, Format.Format23x, 52);
    public static final /* enum */ Opcode MUL_DOUBLE = new Opcode(173, "mul-double", 7, Format.Format23x, 52);
    public static final /* enum */ Opcode DIV_DOUBLE = new Opcode(174, "div-double", 7, Format.Format23x, 52);
    public static final /* enum */ Opcode REM_DOUBLE = new Opcode(175, "rem-double", 7, Format.Format23x, 52);
    public static final /* enum */ Opcode ADD_INT_2ADDR = new Opcode(176, "add-int/2addr", 7, Format.Format12x, 20);
    public static final /* enum */ Opcode SUB_INT_2ADDR = new Opcode(177, "sub-int/2addr", 7, Format.Format12x, 20);
    public static final /* enum */ Opcode MUL_INT_2ADDR = new Opcode(178, "mul-int/2addr", 7, Format.Format12x, 20);
    public static final /* enum */ Opcode DIV_INT_2ADDR = new Opcode(179, "div-int/2addr", 7, Format.Format12x, 21);
    public static final /* enum */ Opcode REM_INT_2ADDR = new Opcode(180, "rem-int/2addr", 7, Format.Format12x, 21);
    public static final /* enum */ Opcode AND_INT_2ADDR = new Opcode(181, "and-int/2addr", 7, Format.Format12x, 20);
    public static final /* enum */ Opcode OR_INT_2ADDR = new Opcode(182, "or-int/2addr", 7, Format.Format12x, 20);
    public static final /* enum */ Opcode XOR_INT_2ADDR = new Opcode(183, "xor-int/2addr", 7, Format.Format12x, 20);
    public static final /* enum */ Opcode SHL_INT_2ADDR = new Opcode(184, "shl-int/2addr", 7, Format.Format12x, 20);
    public static final /* enum */ Opcode SHR_INT_2ADDR = new Opcode(185, "shr-int/2addr", 7, Format.Format12x, 20);
    public static final /* enum */ Opcode USHR_INT_2ADDR = new Opcode(186, "ushr-int/2addr", 7, Format.Format12x, 20);
    public static final /* enum */ Opcode ADD_LONG_2ADDR = new Opcode(187, "add-long/2addr", 7, Format.Format12x, 52);
    public static final /* enum */ Opcode SUB_LONG_2ADDR = new Opcode(188, "sub-long/2addr", 7, Format.Format12x, 52);
    public static final /* enum */ Opcode MUL_LONG_2ADDR = new Opcode(189, "mul-long/2addr", 7, Format.Format12x, 52);
    public static final /* enum */ Opcode DIV_LONG_2ADDR = new Opcode(190, "div-long/2addr", 7, Format.Format12x, 53);
    public static final /* enum */ Opcode REM_LONG_2ADDR = new Opcode(191, "rem-long/2addr", 7, Format.Format12x, 53);
    public static final /* enum */ Opcode AND_LONG_2ADDR = new Opcode(192, "and-long/2addr", 7, Format.Format12x, 52);
    public static final /* enum */ Opcode OR_LONG_2ADDR = new Opcode(193, "or-long/2addr", 7, Format.Format12x, 52);
    public static final /* enum */ Opcode XOR_LONG_2ADDR = new Opcode(194, "xor-long/2addr", 7, Format.Format12x, 52);
    public static final /* enum */ Opcode SHL_LONG_2ADDR = new Opcode(195, "shl-long/2addr", 7, Format.Format12x, 52);
    public static final /* enum */ Opcode SHR_LONG_2ADDR = new Opcode(196, "shr-long/2addr", 7, Format.Format12x, 52);
    public static final /* enum */ Opcode USHR_LONG_2ADDR = new Opcode(197, "ushr-long/2addr", 7, Format.Format12x, 52);
    public static final /* enum */ Opcode ADD_FLOAT_2ADDR = new Opcode(198, "add-float/2addr", 7, Format.Format12x, 20);
    public static final /* enum */ Opcode SUB_FLOAT_2ADDR = new Opcode(199, "sub-float/2addr", 7, Format.Format12x, 20);
    public static final /* enum */ Opcode MUL_FLOAT_2ADDR = new Opcode(200, "mul-float/2addr", 7, Format.Format12x, 20);
    public static final /* enum */ Opcode DIV_FLOAT_2ADDR = new Opcode(201, "div-float/2addr", 7, Format.Format12x, 20);
    public static final /* enum */ Opcode REM_FLOAT_2ADDR = new Opcode(202, "rem-float/2addr", 7, Format.Format12x, 20);
    public static final /* enum */ Opcode ADD_DOUBLE_2ADDR = new Opcode(203, "add-double/2addr", 7, Format.Format12x, 52);
    public static final /* enum */ Opcode SUB_DOUBLE_2ADDR = new Opcode(204, "sub-double/2addr", 7, Format.Format12x, 52);
    public static final /* enum */ Opcode MUL_DOUBLE_2ADDR = new Opcode(205, "mul-double/2addr", 7, Format.Format12x, 52);
    public static final /* enum */ Opcode DIV_DOUBLE_2ADDR = new Opcode(206, "div-double/2addr", 7, Format.Format12x, 52);
    public static final /* enum */ Opcode REM_DOUBLE_2ADDR = new Opcode(207, "rem-double/2addr", 7, Format.Format12x, 52);
    public static final /* enum */ Opcode ADD_INT_LIT16 = new Opcode(208, "add-int/lit16", 7, Format.Format22s, 20);
    public static final /* enum */ Opcode RSUB_INT = new Opcode(209, "rsub-int", 7, Format.Format22s, 20);
    public static final /* enum */ Opcode MUL_INT_LIT16 = new Opcode(210, "mul-int/lit16", 7, Format.Format22s, 20);
    public static final /* enum */ Opcode DIV_INT_LIT16 = new Opcode(211, "div-int/lit16", 7, Format.Format22s, 21);
    public static final /* enum */ Opcode REM_INT_LIT16 = new Opcode(212, "rem-int/lit16", 7, Format.Format22s, 21);
    public static final /* enum */ Opcode AND_INT_LIT16 = new Opcode(213, "and-int/lit16", 7, Format.Format22s, 20);
    public static final /* enum */ Opcode OR_INT_LIT16 = new Opcode(214, "or-int/lit16", 7, Format.Format22s, 20);
    public static final /* enum */ Opcode XOR_INT_LIT16 = new Opcode(215, "xor-int/lit16", 7, Format.Format22s, 20);
    public static final /* enum */ Opcode ADD_INT_LIT8 = new Opcode(216, "add-int/lit8", 7, Format.Format22b, 20);
    public static final /* enum */ Opcode RSUB_INT_LIT8 = new Opcode(217, "rsub-int/lit8", 7, Format.Format22b, 20);
    public static final /* enum */ Opcode MUL_INT_LIT8 = new Opcode(218, "mul-int/lit8", 7, Format.Format22b, 20);
    public static final /* enum */ Opcode DIV_INT_LIT8 = new Opcode(219, "div-int/lit8", 7, Format.Format22b, 21);
    public static final /* enum */ Opcode REM_INT_LIT8 = new Opcode(220, "rem-int/lit8", 7, Format.Format22b, 21);
    public static final /* enum */ Opcode AND_INT_LIT8 = new Opcode(221, "and-int/lit8", 7, Format.Format22b, 20);
    public static final /* enum */ Opcode OR_INT_LIT8 = new Opcode(222, "or-int/lit8", 7, Format.Format22b, 20);
    public static final /* enum */ Opcode XOR_INT_LIT8 = new Opcode(223, "xor-int/lit8", 7, Format.Format22b, 20);
    public static final /* enum */ Opcode SHL_INT_LIT8 = new Opcode(224, "shl-int/lit8", 7, Format.Format22b, 20);
    public static final /* enum */ Opcode SHR_INT_LIT8 = new Opcode(225, "shr-int/lit8", 7, Format.Format22b, 20);
    public static final /* enum */ Opcode USHR_INT_LIT8 = new Opcode(226, "ushr-int/lit8", 7, Format.Format22b, 20);
    public static final /* enum */ Opcode IGET_VOLATILE = new Opcode(Opcode.firstApi(227, 9), "iget-volatile", 2, Format.Format22c, 151);
    public static final /* enum */ Opcode IPUT_VOLATILE = new Opcode(Opcode.firstApi(228, 9), "iput-volatile", 2, Format.Format22c, 135);
    public static final /* enum */ Opcode SGET_VOLATILE = new Opcode(Opcode.firstApi(229, 9), "sget-volatile", 2, Format.Format21c, 407);
    public static final /* enum */ Opcode SPUT_VOLATILE = new Opcode(Opcode.firstApi(230, 9), "sput-volatile", 2, Format.Format21c, 391);
    public static final /* enum */ Opcode IGET_OBJECT_VOLATILE = new Opcode(Opcode.firstApi(231, 9), "iget-object-volatile", 2, Format.Format22c, 151);
    public static final /* enum */ Opcode IGET_WIDE_VOLATILE = new Opcode(Opcode.firstApi(232, 9), "iget-wide-volatile", 2, Format.Format22c, 183);
    public static final /* enum */ Opcode IPUT_WIDE_VOLATILE = new Opcode(Opcode.firstApi(233, 9), "iput-wide-volatile", 2, Format.Format22c, 135);
    public static final /* enum */ Opcode SGET_WIDE_VOLATILE = new Opcode(Opcode.firstApi(234, 9), "sget-wide-volatile", 2, Format.Format21c, 439);
    public static final /* enum */ Opcode SPUT_WIDE_VOLATILE = new Opcode(Opcode.firstApi(235, 9), "sput-wide-volatile", 2, Format.Format21c, 391);
    public static final /* enum */ Opcode THROW_VERIFICATION_ERROR = new Opcode(Opcode.firstApi(237, 5), "throw-verification-error", 7, Format.Format20bc, 3);
    public static final /* enum */ Opcode EXECUTE_INLINE = new Opcode(Opcode.allApis(238), "execute-inline", 7, Format.Format35mi, 15);
    public static final /* enum */ Opcode EXECUTE_INLINE_RANGE = new Opcode(Opcode.firstApi(239, 8), "execute-inline/range", 7, Format.Format3rmi, 15);
    public static final /* enum */ Opcode INVOKE_DIRECT_EMPTY = new Opcode(Opcode.lastApi(240, 13), "invoke-direct-empty", 3, Format.Format35c, 1039);
    public static final /* enum */ Opcode INVOKE_OBJECT_INIT_RANGE = new Opcode(Opcode.firstApi(240, 14), "invoke-object-init/range", 3, Format.Format3rc, 1039);
    public static final /* enum */ Opcode RETURN_VOID_BARRIER = new Opcode(Opcode.combine(Opcode.firstApi(241, 11), Opcode.lastArtVersion(115, 59)), "return-void-barrier", 7, Format.Format10x, 2);
    public static final /* enum */ Opcode RETURN_VOID_NO_BARRIER = new Opcode(Opcode.firstArtVersion(115, 60), "return-void-no-barrier", 7, Format.Format10x, 2);
    public static final /* enum */ Opcode IGET_QUICK = new Opcode(Opcode.combine(Opcode.allApis(242), Opcode.allArtVersions(227)), "iget-quick", 7, Format.Format22cs, 87);
    public static final /* enum */ Opcode IGET_WIDE_QUICK = new Opcode(Opcode.combine(Opcode.allApis(243), Opcode.allArtVersions(228)), "iget-wide-quick", 7, Format.Format22cs, 119);
    public static final /* enum */ Opcode IGET_OBJECT_QUICK = new Opcode(Opcode.combine(Opcode.allApis(244), Opcode.allArtVersions(229)), "iget-object-quick", 7, Format.Format22cs, 87);
    public static final /* enum */ Opcode IPUT_QUICK = new Opcode(Opcode.combine(Opcode.allApis(245), Opcode.allArtVersions(230)), "iput-quick", 7, Format.Format22cs, 71);
    public static final /* enum */ Opcode IPUT_WIDE_QUICK = new Opcode(Opcode.combine(Opcode.allApis(246), Opcode.allArtVersions(231)), "iput-wide-quick", 7, Format.Format22cs, 71);
    public static final /* enum */ Opcode IPUT_OBJECT_QUICK = new Opcode(Opcode.combine(Opcode.allApis(247), Opcode.allArtVersions(232)), "iput-object-quick", 7, Format.Format22cs, 71);
    public static final /* enum */ Opcode IPUT_BOOLEAN_QUICK = new Opcode(Opcode.allArtVersions(235), "iput-boolean-quick", 7, Format.Format22cs, 71);
    public static final /* enum */ Opcode IPUT_BYTE_QUICK = new Opcode(Opcode.allArtVersions(236), "iput-byte-quick", 7, Format.Format22cs, 71);
    public static final /* enum */ Opcode IPUT_CHAR_QUICK = new Opcode(Opcode.allArtVersions(237), "iput-char-quick", 7, Format.Format22cs, 71);
    public static final /* enum */ Opcode IPUT_SHORT_QUICK = new Opcode(Opcode.allArtVersions(238), "iput-short-quick", 7, Format.Format22cs, 71);
    public static final /* enum */ Opcode IGET_BOOLEAN_QUICK = new Opcode(Opcode.allArtVersions(239), "iget-boolean-quick", 7, Format.Format22cs, 87);
    public static final /* enum */ Opcode IGET_BYTE_QUICK = new Opcode(Opcode.allArtVersions(240), "iget-byte-quick", 7, Format.Format22cs, 87);
    public static final /* enum */ Opcode IGET_CHAR_QUICK = new Opcode(Opcode.allArtVersions(241), "iget-char-quick", 7, Format.Format22cs, 87);
    public static final /* enum */ Opcode IGET_SHORT_QUICK = new Opcode(Opcode.allArtVersions(242), "iget-short-quick", 7, Format.Format22cs, 87);
    public static final /* enum */ Opcode INVOKE_VIRTUAL_QUICK = new Opcode(Opcode.combine(Opcode.allApis(248), Opcode.allArtVersions(233)), "invoke-virtual-quick", 7, Format.Format35ms, 15);
    public static final /* enum */ Opcode INVOKE_VIRTUAL_QUICK_RANGE = new Opcode(Opcode.combine(Opcode.allApis(249), Opcode.allArtVersions(234)), "invoke-virtual-quick/range", 7, Format.Format3rms, 15);
    public static final /* enum */ Opcode INVOKE_SUPER_QUICK = new Opcode(Opcode.lastApi(250, 25), "invoke-super-quick", 7, Format.Format35ms, 15);
    public static final /* enum */ Opcode INVOKE_SUPER_QUICK_RANGE = new Opcode(Opcode.lastApi(251, 25), "invoke-super-quick/range", 7, Format.Format3rms, 15);
    public static final /* enum */ Opcode IPUT_OBJECT_VOLATILE = new Opcode(Opcode.firstApi(252, 9), "iput-object-volatile", 2, Format.Format22c, 135);
    public static final /* enum */ Opcode SGET_OBJECT_VOLATILE = new Opcode(Opcode.firstApi(253, 9), "sget-object-volatile", 2, Format.Format21c, 407);
    public static final /* enum */ Opcode SPUT_OBJECT_VOLATILE = new Opcode(Opcode.betweenApi(254, 9, 19), "sput-object-volatile", 2, Format.Format21c, 391);
    public static final /* enum */ Opcode PACKED_SWITCH_PAYLOAD = new Opcode(256, "packed-switch-payload", 7, Format.PackedSwitchPayload, 0);
    public static final /* enum */ Opcode SPARSE_SWITCH_PAYLOAD = new Opcode(512, "sparse-switch-payload", 7, Format.SparseSwitchPayload, 0);
    public static final /* enum */ Opcode ARRAY_PAYLOAD = new Opcode(768, "array-payload", 7, Format.ArrayPayload, 0);
    public static final /* enum */ Opcode INVOKE_POLYMORPHIC = new Opcode(Opcode.firstArtVersion(250, 87), "invoke-polymorphic", 3, 4, Format.Format45cc, 13);
    public static final /* enum */ Opcode INVOKE_POLYMORPHIC_RANGE = new Opcode(Opcode.firstArtVersion(251, 87), "invoke-polymorphic/range", 3, 4, Format.Format4rcc, 13);
    public static final /* enum */ Opcode INVOKE_CUSTOM = new Opcode(Opcode.firstArtVersion(252, 111), "invoke-custom", 5, Format.Format35c, 13);
    public static final /* enum */ Opcode INVOKE_CUSTOM_RANGE = new Opcode(Opcode.firstArtVersion(253, 111), "invoke-custom/range", 5, Format.Format3rc, 13);
    public static final /* enum */ Opcode CONST_METHOD_HANDLE = new Opcode(Opcode.firstArtVersion(254, 134), "const-method-handle", 6, Format.Format21c, 21);
    public static final /* enum */ Opcode CONST_METHOD_TYPE = new Opcode(Opcode.firstArtVersion(255, 134), "const-method-type", 4, Format.Format21c, 21);
    public final RangeMap<Integer, Short> apiToValueMap;
    public final RangeMap<Integer, Short> artVersionToValueMap;
    public final String name;
    public final int referenceType;
    public final Format format;
    public final int flags;
    public final int referenceType2;
    private static final /* synthetic */ Opcode[] $VALUES;

    public static Opcode[] values() {
        return (Opcode[])$VALUES.clone();
    }

    private Opcode(int n2, String string2, int n3, Format format) {
        this(n2, string2, n3, format, 0);
    }

    private Opcode(int n2, String string2, int n3, Format format, int n4) {
        this(Opcode.allVersions(n2), string2, n3, format, n4);
    }

    private Opcode(List<VersionConstraint> list, String string2, int n2, Format format, int n3) {
        this(list, string2, n2, -1, format, n3);
    }

    private Opcode(List<VersionConstraint> list, String string2, int n2, int n3, Format format, int n4) {
        ImmutableRangeMap.Builder<Integer, Short> builder = ImmutableRangeMap.builder();
        ImmutableRangeMap.Builder<Integer, Short> builder2 = ImmutableRangeMap.builder();
        for (VersionConstraint versionConstraint : list) {
            if (!versionConstraint.apiRange.isEmpty()) {
                builder.put(versionConstraint.apiRange, (short)versionConstraint.opcodeValue);
            }
            if (versionConstraint.artVersionRange.isEmpty()) continue;
            builder2.put(versionConstraint.artVersionRange, (short)versionConstraint.opcodeValue);
        }
        this.apiToValueMap = builder.build();
        this.artVersionToValueMap = builder2.build();
        this.name = string2;
        this.referenceType = n2;
        this.referenceType2 = n3;
        this.format = format;
        this.flags = n4;
    }

    private static List<VersionConstraint> firstApi(int n, int n2) {
        return Lists.newArrayList(new VersionConstraint(Range.atLeast(n2), Range.openClosed(0, 0), n));
    }

    private static List<VersionConstraint> lastApi(int n, int n2) {
        return Lists.newArrayList(new VersionConstraint(Range.atMost(n2), Range.openClosed(0, 0), n));
    }

    private static List<VersionConstraint> betweenApi(int n, int n2, int n3) {
        return Lists.newArrayList(new VersionConstraint(Range.closed(n2, n3), Range.openClosed(0, 0), n));
    }

    private static List<VersionConstraint> firstArtVersion(int n, int n2) {
        return Lists.newArrayList(new VersionConstraint(Range.openClosed(0, 0), Range.atLeast(n2), n));
    }

    private static List<VersionConstraint> lastArtVersion(int n, int n2) {
        return Lists.newArrayList(new VersionConstraint(Range.openClosed(0, 0), Range.atMost(n2), n));
    }

    private static List<VersionConstraint> allVersions(int n) {
        return Lists.newArrayList(new VersionConstraint(Range.all(), Range.all(), n));
    }

    private static List<VersionConstraint> allApis(int n) {
        return Lists.newArrayList(new VersionConstraint(Range.all(), Range.openClosed(0, 0), n));
    }

    private static List<VersionConstraint> allArtVersions(int n) {
        return Lists.newArrayList(new VersionConstraint(Range.openClosed(0, 0), Range.all(), n));
    }

    private static List<VersionConstraint> combine(List<VersionConstraint> ... listArray) {
        ArrayList<VersionConstraint> arrayList = Lists.newArrayList();
        for (List<VersionConstraint> list : listArray) {
            arrayList.addAll(list);
        }
        return arrayList;
    }

    static {
        $VALUES = new Opcode[]{NOP, MOVE, MOVE_FROM16, MOVE_16, MOVE_WIDE, MOVE_WIDE_FROM16, MOVE_WIDE_16, MOVE_OBJECT, MOVE_OBJECT_FROM16, MOVE_OBJECT_16, MOVE_RESULT, MOVE_RESULT_WIDE, MOVE_RESULT_OBJECT, MOVE_EXCEPTION, RETURN_VOID, RETURN, RETURN_WIDE, RETURN_OBJECT, CONST_4, CONST_16, CONST, CONST_HIGH16, CONST_WIDE_16, CONST_WIDE_32, CONST_WIDE, CONST_WIDE_HIGH16, CONST_STRING, CONST_STRING_JUMBO, CONST_CLASS, MONITOR_ENTER, MONITOR_EXIT, CHECK_CAST, INSTANCE_OF, ARRAY_LENGTH, NEW_INSTANCE, NEW_ARRAY, FILLED_NEW_ARRAY, FILLED_NEW_ARRAY_RANGE, FILL_ARRAY_DATA, THROW, GOTO, GOTO_16, GOTO_32, PACKED_SWITCH, SPARSE_SWITCH, CMPL_FLOAT, CMPG_FLOAT, CMPL_DOUBLE, CMPG_DOUBLE, CMP_LONG, IF_EQ, IF_NE, IF_LT, IF_GE, IF_GT, IF_LE, IF_EQZ, IF_NEZ, IF_LTZ, IF_GEZ, IF_GTZ, IF_LEZ, AGET, AGET_WIDE, AGET_OBJECT, AGET_BOOLEAN, AGET_BYTE, AGET_CHAR, AGET_SHORT, APUT, APUT_WIDE, APUT_OBJECT, APUT_BOOLEAN, APUT_BYTE, APUT_CHAR, APUT_SHORT, IGET, IGET_WIDE, IGET_OBJECT, IGET_BOOLEAN, IGET_BYTE, IGET_CHAR, IGET_SHORT, IPUT, IPUT_WIDE, IPUT_OBJECT, IPUT_BOOLEAN, IPUT_BYTE, IPUT_CHAR, IPUT_SHORT, SGET, SGET_WIDE, SGET_OBJECT, SGET_BOOLEAN, SGET_BYTE, SGET_CHAR, SGET_SHORT, SPUT, SPUT_WIDE, SPUT_OBJECT, SPUT_BOOLEAN, SPUT_BYTE, SPUT_CHAR, SPUT_SHORT, INVOKE_VIRTUAL, INVOKE_SUPER, INVOKE_DIRECT, INVOKE_STATIC, INVOKE_INTERFACE, INVOKE_VIRTUAL_RANGE, INVOKE_SUPER_RANGE, INVOKE_DIRECT_RANGE, INVOKE_STATIC_RANGE, INVOKE_INTERFACE_RANGE, NEG_INT, NOT_INT, NEG_LONG, NOT_LONG, NEG_FLOAT, NEG_DOUBLE, INT_TO_LONG, INT_TO_FLOAT, INT_TO_DOUBLE, LONG_TO_INT, LONG_TO_FLOAT, LONG_TO_DOUBLE, FLOAT_TO_INT, FLOAT_TO_LONG, FLOAT_TO_DOUBLE, DOUBLE_TO_INT, DOUBLE_TO_LONG, DOUBLE_TO_FLOAT, INT_TO_BYTE, INT_TO_CHAR, INT_TO_SHORT, ADD_INT, SUB_INT, MUL_INT, DIV_INT, REM_INT, AND_INT, OR_INT, XOR_INT, SHL_INT, SHR_INT, USHR_INT, ADD_LONG, SUB_LONG, MUL_LONG, DIV_LONG, REM_LONG, AND_LONG, OR_LONG, XOR_LONG, SHL_LONG, SHR_LONG, USHR_LONG, ADD_FLOAT, SUB_FLOAT, MUL_FLOAT, DIV_FLOAT, REM_FLOAT, ADD_DOUBLE, SUB_DOUBLE, MUL_DOUBLE, DIV_DOUBLE, REM_DOUBLE, ADD_INT_2ADDR, SUB_INT_2ADDR, MUL_INT_2ADDR, DIV_INT_2ADDR, REM_INT_2ADDR, AND_INT_2ADDR, OR_INT_2ADDR, XOR_INT_2ADDR, SHL_INT_2ADDR, SHR_INT_2ADDR, USHR_INT_2ADDR, ADD_LONG_2ADDR, SUB_LONG_2ADDR, MUL_LONG_2ADDR, DIV_LONG_2ADDR, REM_LONG_2ADDR, AND_LONG_2ADDR, OR_LONG_2ADDR, XOR_LONG_2ADDR, SHL_LONG_2ADDR, SHR_LONG_2ADDR, USHR_LONG_2ADDR, ADD_FLOAT_2ADDR, SUB_FLOAT_2ADDR, MUL_FLOAT_2ADDR, DIV_FLOAT_2ADDR, REM_FLOAT_2ADDR, ADD_DOUBLE_2ADDR, SUB_DOUBLE_2ADDR, MUL_DOUBLE_2ADDR, DIV_DOUBLE_2ADDR, REM_DOUBLE_2ADDR, ADD_INT_LIT16, RSUB_INT, MUL_INT_LIT16, DIV_INT_LIT16, REM_INT_LIT16, AND_INT_LIT16, OR_INT_LIT16, XOR_INT_LIT16, ADD_INT_LIT8, RSUB_INT_LIT8, MUL_INT_LIT8, DIV_INT_LIT8, REM_INT_LIT8, AND_INT_LIT8, OR_INT_LIT8, XOR_INT_LIT8, SHL_INT_LIT8, SHR_INT_LIT8, USHR_INT_LIT8, IGET_VOLATILE, IPUT_VOLATILE, SGET_VOLATILE, SPUT_VOLATILE, IGET_OBJECT_VOLATILE, IGET_WIDE_VOLATILE, IPUT_WIDE_VOLATILE, SGET_WIDE_VOLATILE, SPUT_WIDE_VOLATILE, THROW_VERIFICATION_ERROR, EXECUTE_INLINE, EXECUTE_INLINE_RANGE, INVOKE_DIRECT_EMPTY, INVOKE_OBJECT_INIT_RANGE, RETURN_VOID_BARRIER, RETURN_VOID_NO_BARRIER, IGET_QUICK, IGET_WIDE_QUICK, IGET_OBJECT_QUICK, IPUT_QUICK, IPUT_WIDE_QUICK, IPUT_OBJECT_QUICK, IPUT_BOOLEAN_QUICK, IPUT_BYTE_QUICK, IPUT_CHAR_QUICK, IPUT_SHORT_QUICK, IGET_BOOLEAN_QUICK, IGET_BYTE_QUICK, IGET_CHAR_QUICK, IGET_SHORT_QUICK, INVOKE_VIRTUAL_QUICK, INVOKE_VIRTUAL_QUICK_RANGE, INVOKE_SUPER_QUICK, INVOKE_SUPER_QUICK_RANGE, IPUT_OBJECT_VOLATILE, SGET_OBJECT_VOLATILE, SPUT_OBJECT_VOLATILE, PACKED_SWITCH_PAYLOAD, SPARSE_SWITCH_PAYLOAD, ARRAY_PAYLOAD, INVOKE_POLYMORPHIC, INVOKE_POLYMORPHIC_RANGE, INVOKE_CUSTOM, INVOKE_CUSTOM_RANGE, CONST_METHOD_HANDLE, CONST_METHOD_TYPE};
    }

    private static class VersionConstraint {
        public final Range<Integer> apiRange;
        public final Range<Integer> artVersionRange;
        public final int opcodeValue;

        public VersionConstraint(Range<Integer> range, Range<Integer> range2, int n) {
            this.apiRange = range;
            this.artVersionRange = range2;
            this.opcodeValue = n;
        }
    }
}

