/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.util;

import com.github.tmurakami.dexopener.repackaged.org.jf.util.AbstractListIterator;
import java.util.AbstractSequentialList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public abstract class AbstractForwardSequentialList<T>
extends AbstractSequentialList<T> {
    private Iterator<T> iterator(int n) {
        if (n < 0) {
            throw new NoSuchElementException();
        }
        Iterator<T> iterator = this.iterator();
        for (int i = 0; i < n; ++i) {
            iterator.next();
        }
        return iterator;
    }

    @Override
    public abstract Iterator<T> iterator();

    @Override
    public ListIterator<T> listIterator(final int n) {
        Iterator<T> iterator;
        try {
            iterator = this.iterator(n);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IndexOutOfBoundsException();
        }
        return new AbstractListIterator<T>(){
            private int index;
            private Iterator<T> forwardIterator;
            {
                this.index = n - 1;
                this.forwardIterator = iterator;
            }

            private Iterator<T> getForwardIterator() {
                if (this.forwardIterator == null) {
                    try {
                        this.forwardIterator = AbstractForwardSequentialList.this.iterator(this.index + 1);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        throw new NoSuchElementException();
                    }
                }
                return this.forwardIterator;
            }

            @Override
            public boolean hasNext() {
                return this.getForwardIterator().hasNext();
            }

            @Override
            public boolean hasPrevious() {
                return this.index >= 0;
            }

            @Override
            public T next() {
                Object t = this.getForwardIterator().next();
                ++this.index;
                return t;
            }

            @Override
            public int nextIndex() {
                return this.index + 1;
            }

            @Override
            public T previous() {
                this.forwardIterator = null;
                try {
                    return AbstractForwardSequentialList.this.iterator(this.index--).next();
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw new NoSuchElementException();
                }
            }

            @Override
            public int previousIndex() {
                return this.index;
            }
        };
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.listIterator(0);
    }
}

