/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.io;

import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.Lists;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.io.DeferredOutputStream;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.io.DeferredOutputStreamFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

public class MemoryDeferredOutputStream
extends DeferredOutputStream {
    private final List<byte[]> buffers = Lists.newArrayList();
    private byte[] currentBuffer;
    private int currentPosition;

    public MemoryDeferredOutputStream() {
        this(16384);
    }

    public MemoryDeferredOutputStream(int n) {
        this.currentBuffer = new byte[n];
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        for (byte[] byArray : this.buffers) {
            outputStream.write(byArray);
        }
        if (this.currentPosition > 0) {
            outputStream.write(this.currentBuffer, 0, this.currentPosition);
        }
        this.buffers.clear();
        this.currentPosition = 0;
    }

    @Override
    public void write(int n) throws IOException {
        if (this.remaining() == 0) {
            this.buffers.add(this.currentBuffer);
            this.currentBuffer = new byte[this.currentBuffer.length];
            this.currentPosition = 0;
        }
        this.currentBuffer[this.currentPosition++] = (byte)n;
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.remaining();
        int n4 = 0;
        while (n2 - n4 > 0) {
            int n5 = Math.min(n3, n2 - n4);
            System.arraycopy(byArray, n + n4, this.currentBuffer, this.currentPosition, n5);
            n4 += n5;
            this.currentPosition += n5;
            n3 = this.remaining();
            if (n3 != 0) continue;
            this.buffers.add(this.currentBuffer);
            this.currentBuffer = new byte[this.currentBuffer.length];
            this.currentPosition = 0;
            n3 = this.currentBuffer.length;
        }
    }

    private int remaining() {
        return this.currentBuffer.length - this.currentPosition;
    }

    public static DeferredOutputStreamFactory getFactory() {
        return MemoryDeferredOutputStream.getFactory(16384);
    }

    public static DeferredOutputStreamFactory getFactory(final int n) {
        return new DeferredOutputStreamFactory(){

            @Override
            public DeferredOutputStream makeDeferredOutputStream() {
                return new MemoryDeferredOutputStream(n);
            }
        };
    }
}

