/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2;

import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.Maps;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.RangeMap;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.Opcode;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.VersionMap;
import java.util.EnumMap;
import java.util.HashMap;

public class Opcodes {
    public final int api;
    public final int artVersion;
    private final Opcode[] opcodesByValue = new Opcode[256];
    private final EnumMap<Opcode, Short> opcodeValues;
    private final HashMap<String, Opcode> opcodesByName;

    public static Opcodes forDexVersion(int n) {
        int n2 = VersionMap.mapDexVersionToApi(n);
        if (n2 == -1) {
            throw new RuntimeException("Unsupported dex version " + n);
        }
        return new Opcodes(n2, -1);
    }

    private Opcodes(int n, int n2) {
        if (n >= 21) {
            this.api = n;
            this.artVersion = VersionMap.mapApiToArtVersion(n);
        } else if (n2 >= 0 && n2 < 39) {
            this.api = VersionMap.mapArtVersionToApi(n2);
            this.artVersion = n2;
        } else {
            this.api = n;
            this.artVersion = n2;
        }
        this.opcodeValues = new EnumMap(Opcode.class);
        this.opcodesByName = Maps.newHashMap();
        int n3 = this.isArt() ? this.artVersion : this.api;
        for (Opcode opcode : Opcode.values()) {
            RangeMap<Integer, Short> rangeMap = this.isArt() ? opcode.artVersionToValueMap : opcode.apiToValueMap;
            Short s = rangeMap.get(n3);
            if (s == null) continue;
            if (!opcode.format.isPayloadFormat) {
                this.opcodesByValue[s.shortValue()] = opcode;
            }
            this.opcodeValues.put(opcode, s);
            this.opcodesByName.put(opcode.name.toLowerCase(), opcode);
        }
    }

    public Opcode getOpcodeByValue(int n) {
        switch (n) {
            case 256: {
                return Opcode.PACKED_SWITCH_PAYLOAD;
            }
            case 512: {
                return Opcode.SPARSE_SWITCH_PAYLOAD;
            }
            case 768: {
                return Opcode.ARRAY_PAYLOAD;
            }
        }
        if (n >= 0 && n < this.opcodesByValue.length) {
            return this.opcodesByValue[n];
        }
        return null;
    }

    public Short getOpcodeValue(Opcode opcode) {
        return this.opcodeValues.get((Object)opcode);
    }

    public boolean isArt() {
        return this.artVersion != -1;
    }
}

