/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.util;

import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableSet;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.AccessFlags;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexBackedDexFile;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexBackedMethod;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexBackedMethodImplementation;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexReader;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.util.ParameterIterator;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.util.VariableSizeIterator;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.util.VariableSizeLookaheadIterator;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.debug.DebugItem;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.debug.EndLocal;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.debug.LocalInfo;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.debug.ImmutableEndLocal;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.debug.ImmutableEpilogueBegin;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.debug.ImmutableLineNumber;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.debug.ImmutablePrologueEnd;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.debug.ImmutableRestartLocal;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.debug.ImmutableSetSourceFile;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.debug.ImmutableStartLocal;
import java.util.Arrays;
import java.util.Iterator;

public abstract class DebugInfo
implements Iterable<DebugItem> {
    public abstract Iterator<String> getParameterNames(DexReader var1);

    public static DebugInfo newOrEmpty(DexBackedDexFile dexBackedDexFile, int n, DexBackedMethodImplementation dexBackedMethodImplementation) {
        if (n == 0) {
            return EmptyDebugInfo.INSTANCE;
        }
        return new DebugInfoImpl(dexBackedDexFile, n, dexBackedMethodImplementation);
    }

    private static class DebugInfoImpl
    extends DebugInfo {
        public final DexBackedDexFile dexFile;
        private final int debugInfoOffset;
        private final DexBackedMethodImplementation methodImpl;
        private static final LocalInfo EMPTY_LOCAL_INFO = new LocalInfo(){

            @Override
            public String getName() {
                return null;
            }

            @Override
            public String getType() {
                return null;
            }

            @Override
            public String getSignature() {
                return null;
            }
        };

        public DebugInfoImpl(DexBackedDexFile dexBackedDexFile, int n, DexBackedMethodImplementation dexBackedMethodImplementation) {
            this.dexFile = dexBackedDexFile;
            this.debugInfoOffset = n;
            this.methodImpl = dexBackedMethodImplementation;
        }

        @Override
        public Iterator<DebugItem> iterator() {
            DexReader dexReader = this.dexFile.readerAt(this.debugInfoOffset);
            final int n = dexReader.readBigUleb128();
            int n2 = this.methodImpl.getRegisterCount();
            Object[] objectArray = new LocalInfo[n2];
            Arrays.fill(objectArray, EMPTY_LOCAL_INFO);
            DexBackedMethod dexBackedMethod = this.methodImpl.method;
            ParameterIterator parameterIterator = new ParameterIterator(dexBackedMethod.getParameterTypes(), dexBackedMethod.getParameterAnnotations(), this.getParameterNames(dexReader));
            int n3 = 0;
            if (!AccessFlags.STATIC.isSet(this.methodImpl.method.getAccessFlags())) {
                objectArray[n3++] = new LocalInfo(){

                    @Override
                    public String getName() {
                        return "this";
                    }

                    @Override
                    public String getType() {
                        return ((DebugInfoImpl)this).methodImpl.method.getDefiningClass();
                    }

                    @Override
                    public String getSignature() {
                        return null;
                    }
                };
            }
            while (parameterIterator.hasNext()) {
                objectArray[n3++] = (LocalInfo)parameterIterator.next();
            }
            if (n3 < n2) {
                Object object;
                String string;
                int n4 = n2 - 1;
                while (--n3 > -1 && ((string = (object = objectArray[n3]).getType()) == null || !string.equals("J") && !string.equals("D") || --n4 != n3)) {
                    objectArray[n4] = object;
                    objectArray[n3] = EMPTY_LOCAL_INFO;
                    --n4;
                }
            }
            return new VariableSizeLookaheadIterator<DebugItem>(this.dexFile, dexReader.getOffset(), (LocalInfo[])objectArray){
                private int codeAddress;
                private int lineNumber;
                final /* synthetic */ LocalInfo[] val$locals;
                {
                    this.val$locals = localInfoArray;
                    super(dexBackedDexFile, n3);
                    this.codeAddress = 0;
                    this.lineNumber = n;
                }

                @Override
                protected DebugItem readNextItem(DexReader dexReader) {
                    int n3;
                    int n2;
                    block12: while (true) {
                        n2 = dexReader.readUbyte();
                        switch (n2) {
                            case 0: {
                                return (DebugItem)this.endOfData();
                            }
                            case 1: {
                                n3 = dexReader.readSmallUleb128();
                                this.codeAddress += n3;
                                continue block12;
                            }
                            case 2: {
                                n3 = dexReader.readSleb128();
                                this.lineNumber += n3;
                                continue block12;
                            }
                            case 3: {
                                n3 = dexReader.readSmallUleb128();
                                String string = dexFile.getOptionalString(dexReader.readSmallUleb128() - 1);
                                String string2 = dexFile.getOptionalType(dexReader.readSmallUleb128() - 1);
                                ImmutableStartLocal immutableStartLocal = new ImmutableStartLocal(this.codeAddress, n3, string, string2, null);
                                if (n3 >= 0 && n3 < this.val$locals.length) {
                                    this.val$locals[n3] = immutableStartLocal;
                                }
                                return immutableStartLocal;
                            }
                            case 4: {
                                n3 = dexReader.readSmallUleb128();
                                String string = dexFile.getOptionalString(dexReader.readSmallUleb128() - 1);
                                String string3 = dexFile.getOptionalType(dexReader.readSmallUleb128() - 1);
                                String string4 = dexFile.getOptionalString(dexReader.readSmallUleb128() - 1);
                                ImmutableStartLocal immutableStartLocal = new ImmutableStartLocal(this.codeAddress, n3, string, string3, string4);
                                if (n3 >= 0 && n3 < this.val$locals.length) {
                                    this.val$locals[n3] = immutableStartLocal;
                                }
                                return immutableStartLocal;
                            }
                            case 5: {
                                LocalInfo localInfo;
                                n3 = dexReader.readSmallUleb128();
                                boolean bl = true;
                                if (n3 >= 0 && n3 < this.val$locals.length) {
                                    localInfo = this.val$locals[n3];
                                } else {
                                    localInfo = EMPTY_LOCAL_INFO;
                                    bl = false;
                                }
                                if (localInfo instanceof EndLocal) {
                                    localInfo = EMPTY_LOCAL_INFO;
                                    bl = false;
                                }
                                ImmutableEndLocal immutableEndLocal = new ImmutableEndLocal(this.codeAddress, n3, localInfo.getName(), localInfo.getType(), localInfo.getSignature());
                                if (bl) {
                                    this.val$locals[n3] = immutableEndLocal;
                                }
                                return immutableEndLocal;
                            }
                            case 6: {
                                n3 = dexReader.readSmallUleb128();
                                LocalInfo localInfo = n3 >= 0 && n3 < this.val$locals.length ? this.val$locals[n3] : EMPTY_LOCAL_INFO;
                                ImmutableRestartLocal immutableRestartLocal = new ImmutableRestartLocal(this.codeAddress, n3, localInfo.getName(), localInfo.getType(), localInfo.getSignature());
                                if (n3 >= 0 && n3 < this.val$locals.length) {
                                    this.val$locals[n3] = immutableRestartLocal;
                                }
                                return immutableRestartLocal;
                            }
                            case 7: {
                                return new ImmutablePrologueEnd(this.codeAddress);
                            }
                            case 8: {
                                return new ImmutableEpilogueBegin(this.codeAddress);
                            }
                            case 9: {
                                String string = dexFile.getOptionalString(dexReader.readSmallUleb128() - 1);
                                return new ImmutableSetSourceFile(this.codeAddress, string);
                            }
                        }
                        break;
                    }
                    n3 = n2 - 10;
                    this.codeAddress += n3 / 15;
                    this.lineNumber += n3 % 15 - 4;
                    return new ImmutableLineNumber(this.codeAddress, this.lineNumber);
                }
            };
        }

        public VariableSizeIterator<String> getParameterNames(DexReader dexReader) {
            if (dexReader == null) {
                dexReader = this.dexFile.readerAt(this.debugInfoOffset);
                dexReader.skipUleb128();
            }
            int n = dexReader.readSmallUleb128();
            return new VariableSizeIterator<String>(dexReader, n){

                @Override
                protected String readNextItem(DexReader dexReader, int n) {
                    return dexFile.getOptionalString(dexReader.readSmallUleb128() - 1);
                }
            };
        }
    }

    private static class EmptyDebugInfo
    extends DebugInfo {
        public static final EmptyDebugInfo INSTANCE = new EmptyDebugInfo();

        private EmptyDebugInfo() {
        }

        @Override
        public Iterator<DebugItem> iterator() {
            return ImmutableSet.of().iterator();
        }

        @Override
        public Iterator<String> getParameterNames(DexReader dexReader) {
            return ImmutableSet.of().iterator();
        }
    }
}

