/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.structureWriter;

import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.DebugInstruction;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.DebugInstructionAdvanceLine;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.DebugInstructionAdvancePC;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.DebugInstructionEndLocal;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.DebugInstructionRestartLocal;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.DebugInstructionSetPrologueEnd;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.DebugInstructionSpecialOpcode;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.DebugInstructionStartLocal;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.DebugInstructionStartLocalExtended;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.Instruction;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.lowLevelUtils.ByteVector;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.lowLevelUtils.DalvikValueReader;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.structureCommon.Label;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.structureCommon.LocalVariable;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.structureWriter.CodeItem;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.structureWriter.ConstantPool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;

public class DebugInfoItem {
    private ByteVector debugCode;
    private boolean areSymbolicIndexesUsed;
    private int debugAddress = 0;
    private int debugLine;
    private boolean isFirstInstruction = true;
    private final ConstantPool constantPool;
    private HashMap<Integer, List<DebugInstruction>> offsetToDebugInstructions = new HashMap();

    public DebugInfoItem(ConstantPool constantPool) {
        this.constantPool = constantPool;
    }

    public void free() {
        this.offsetToDebugInstructions = null;
    }

    /*
     * WARNING - void declaration
     */
    public void initializeDebugInfoItem(String[] parameters, CodeItem codeItem, List<LocalVariable> localVariables) {
        int firstLineFound;
        this.debugCode = new ByteVector();
        this.offsetToDebugInstructions.clear();
        boolean bl = this.areSymbolicIndexesUsed = localVariables.size() > 0;
        if (localVariables.size() > 0) {
            TreeSet<Object> items = new TreeSet<Object>();
            for (LocalVariable localVariable : localVariables) {
                LocalVariableItem item;
                Label start = localVariable.getStart();
                if (start != null) {
                    LocalVariableItem item2 = new LocalVariableItem(LocalVariableType.local, localVariable.getRegister(), localVariable.getName(), start, localVariable.getSignature(), localVariable.getType());
                    items.add(item2);
                }
                if (localVariable.getEnds() != null) {
                    for (Label end : localVariable.getEnds()) {
                        item = new LocalVariableItem(LocalVariableType.end, localVariable.getRegister(), localVariable.getName(), end, localVariable.getSignature(), localVariable.getType());
                        items.add(item);
                    }
                }
                if (localVariable.getRestarts() == null) continue;
                for (Label restart : localVariable.getRestarts()) {
                    item = new LocalVariableItem(LocalVariableType.restart, localVariable.getRegister(), localVariable.getName(), restart, localVariable.getSignature(), localVariable.getType());
                    items.add(item);
                }
            }
            block10: for (LocalVariableItem localVariableItem : items) {
                switch (localVariableItem.localVariableType) {
                    case end: {
                        DebugInstruction insn = new DebugInstructionEndLocal(localVariableItem.register, localVariableItem.label);
                        this.addDebugInstruction(localVariableItem.label.getOffset(), insn);
                        continue block10;
                    }
                    case local: {
                        String signature = localVariableItem.signature;
                        DebugInstruction insn = signature == null ? new DebugInstructionStartLocal(localVariableItem.register, localVariableItem.name, localVariableItem.type, localVariableItem.label) : new DebugInstructionStartLocalExtended(localVariableItem.register, localVariableItem.name, localVariableItem.type, signature, localVariableItem.label);
                        this.addDebugInstruction(localVariableItem.label.getOffset(), insn);
                        continue block10;
                    }
                    case restart: {
                        DebugInstruction insn = new DebugInstructionRestartLocal(localVariableItem.register, localVariableItem.label);
                        this.addDebugInstruction(localVariableItem.label.getOffset(), insn);
                        continue block10;
                    }
                }
                try {
                    throw new IllegalArgumentException("Unknown Local Variable type.");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        this.debugLine = (firstLineFound = codeItem.getFirstLineNumber()) == 0 ? 1 : firstLineFound;
        this.debugCode.putUleb128(this.debugLine);
        int parameterCount = parameters == null ? 0 : parameters.length;
        this.debugCode.putUleb128(parameterCount);
        if (parameterCount > 0) {
            void var6_12;
            this.areSymbolicIndexesUsed = true;
            boolean bl2 = false;
            while (var6_12 < parameterCount) {
                int parameterIndex = parameters[var6_12].equals("") ? -1 : this.constantPool.getStringIndex(parameters[var6_12]);
                this.debugCode.putUleb128p1(parameterIndex);
                ++var6_12;
            }
        }
    }

    public void parseDebugInformation(Instruction instruction, int address) {
        int newLineNumber;
        if (this.isFirstInstruction) {
            this.encodeDebugSetPrologueEnd();
            this.isFirstInstruction = false;
        }
        if ((newLineNumber = instruction.getLineNumber()) > 0) {
            boolean isDeltaOffsetWithinLimit;
            int deltaLine = newLineNumber - this.debugLine;
            int deltaOffset = address - this.debugAddress;
            int deltaOffsetInWord = deltaOffset / 2;
            boolean isDeltaLineWithinLimit = deltaLine <= 10 && deltaLine >= -4;
            boolean bl = isDeltaOffsetWithinLimit = deltaOffsetInWord >= 0 && deltaOffsetInWord <= 15;
            if (!isDeltaOffsetWithinLimit) {
                this.encodeDebugAdvancePC(deltaOffsetInWord);
            }
            if (!isDeltaLineWithinLimit) {
                this.encodeDebugAdvanceLine(deltaLine);
            }
            this.encodeDebugSpecialOpcode(isDeltaOffsetWithinLimit ? deltaOffsetInWord : 0, isDeltaLineWithinLimit ? deltaLine : 0);
            this.debugLine = newLineNumber;
            this.debugAddress = address;
        }
        if (this.offsetToDebugInstructions.containsKey(address)) {
            for (DebugInstruction debugInstruction : this.offsetToDebugInstructions.get(address)) {
                if (address != this.debugAddress) {
                    this.encodeDebugAdvancePC((address - this.debugAddress) / 2);
                }
                this.debugAddress = address;
                debugInstruction.write(this.debugCode, this.constantPool);
            }
        }
    }

    public void closeDebugInfoItem() {
        if (this.debugCode.getLength() > 0) {
            this.debugCode.putByte(0);
        }
    }

    public ByteVector mapResolvedIndexes(ByteVector in, int offsetInputBuffer) {
        byte[] data = in.getBuffer();
        DalvikValueReader reader = new DalvikValueReader(data);
        reader.seek(offsetInputBuffer);
        ByteVector out = new ByteVector();
        out.putUleb128(reader.uleb128());
        int nbParameters = reader.uleb128();
        out.putUleb128(nbParameters);
        for (int i = 0; i < nbParameters; ++i) {
            this.mapResolvedIndexFromSymbolicIndex(out, reader.uleb128_p1(), true);
        }
        boolean continueParsing = true;
        while (continueParsing) {
            short opcode = reader.ubyte();
            out.putByte(opcode);
            switch (opcode) {
                case 1: 
                case 5: 
                case 6: {
                    out.putUleb128(reader.uleb128());
                    break;
                }
                case 2: {
                    out.putSleb128(reader.sleb128());
                    break;
                }
                case 9: {
                    this.mapResolvedIndexFromSymbolicIndex(out, reader.uleb128_p1(), true);
                    break;
                }
                case 3: {
                    out.putUleb128(reader.uleb128());
                    this.mapResolvedIndexFromSymbolicIndex(out, reader.uleb128_p1(), true);
                    this.mapResolvedIndexFromSymbolicIndex(out, reader.uleb128_p1(), false);
                    break;
                }
                case 4: {
                    out.putUleb128(reader.uleb128());
                    this.mapResolvedIndexFromSymbolicIndex(out, reader.uleb128_p1(), true);
                    this.mapResolvedIndexFromSymbolicIndex(out, reader.uleb128_p1(), false);
                    this.mapResolvedIndexFromSymbolicIndex(out, reader.uleb128_p1(), true);
                    break;
                }
                case 0: {
                    continueParsing = false;
                }
            }
        }
        return out;
    }

    private void mapResolvedIndexFromSymbolicIndex(ByteVector out, int symbolicIndex, boolean isStringIndex) {
        int resolvedIndex = symbolicIndex != -1 ? (isStringIndex ? this.constantPool.getResolvedStringIndexFromSymbolicStringIndex(symbolicIndex) : this.constantPool.getResolvedTypeIndexFromSymbolicTypeIndex(symbolicIndex)) : -1;
        out.putUleb128p1(resolvedIndex);
    }

    public ByteVector getDebugInfoItemCode() {
        return this.debugCode;
    }

    public boolean areSymbolicIndexesUsed() {
        return this.areSymbolicIndexesUsed;
    }

    private void addDebugInstruction(int offset, DebugInstruction insn) {
        List<Object> list;
        if (!this.offsetToDebugInstructions.containsKey(offset)) {
            list = new ArrayList(1);
            this.offsetToDebugInstructions.put(offset, list);
        } else {
            list = this.offsetToDebugInstructions.get(offset);
        }
        list.add(insn);
    }

    private void encodeDebugAdvancePC(int deltaOffsetInWord) {
        DebugInstructionAdvancePC insn = new DebugInstructionAdvancePC(deltaOffsetInWord);
        ((DebugInstruction)insn).write(this.debugCode, this.constantPool);
    }

    private void encodeDebugAdvanceLine(int deltaLine) {
        DebugInstructionAdvanceLine insn = new DebugInstructionAdvanceLine(deltaLine);
        ((DebugInstruction)insn).write(this.debugCode, this.constantPool);
    }

    private void encodeDebugSetPrologueEnd() {
        DebugInstructionSetPrologueEnd insn = new DebugInstructionSetPrologueEnd();
        ((DebugInstruction)insn).write(this.debugCode, this.constantPool);
    }

    private void encodeDebugSpecialOpcode(int deltaOffsetInWord, int deltaLine) {
        DebugInstructionSpecialOpcode insn = new DebugInstructionSpecialOpcode(deltaOffsetInWord, deltaLine);
        ((DebugInstruction)insn).write(this.debugCode, this.constantPool);
    }

    private static class LocalVariableItem
    implements Comparable<LocalVariableItem> {
        public LocalVariableType localVariableType;
        public int register;
        public String name;
        public Label label;
        public String signature;
        public String type;

        public LocalVariableItem(LocalVariableType localVariableType, int register, String name, Label label, String signature, String type) {
            this.localVariableType = localVariableType;
            this.register = register;
            this.name = name;
            this.label = label;
            this.signature = signature;
            this.type = type;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof LocalVariableItem) {
                boolean result;
                LocalVariableItem lvi = (LocalVariableItem)obj;
                boolean bl = result = this.name.equals(lvi.name) && this.register == lvi.register && this.localVariableType == lvi.localVariableType && this.label.equals(lvi.label) && this.type.equals(lvi.type);
                if (result) {
                    result = this.signature != null ? this.signature.equals(lvi.signature) : lvi.signature == null;
                }
                return result;
            }
            return false;
        }

        public int hashCode() {
            int result = this.signature != null ? this.signature.hashCode() : 0;
            return result += this.localVariableType.hashCode() + this.register * 33 + this.name.hashCode() + this.label.hashCode() + this.type.hashCode();
        }

        @Override
        public int compareTo(LocalVariableItem var) {
            int result;
            if (this == var) {
                return 0;
            }
            if (this.localVariableType == var.localVariableType) {
                int n = this.register == var.register ? 0 : (result = this.register > var.register ? 1 : -1);
                if (result == 0) {
                    int offset2;
                    int offset1 = this.label.getOffset();
                    result = offset1 == (offset2 = var.label.getOffset()) ? 0 : (offset1 > offset2 ? 1 : -1);
                }
            } else {
                int type2;
                int type1 = this.localVariableType.id;
                result = type1 == (type2 = var.localVariableType.id) ? 0 : (type1 > type2 ? 1 : -1);
            }
            return result;
        }
    }

    private static enum LocalVariableType {
        end(0),
        local(1),
        restart(2);

        private final int id;

        private LocalVariableType(int id) {
            this.id = id;
        }
    }
}

