/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.lowLevelUtils;

import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.lowLevelUtils.DalvikValueReader;
import java.io.IOException;
import java.util.Arrays;

public class BasicDexFileReader {
    public static final int NO_INDEX = -1;
    protected DalvikValueReader reader;
    private byte[] magic = new byte[8];
    private static final byte[] MAGIC_TEMPLATE = new byte[]{100, 101, 120, 10, 48, 51, 53, 0};
    private static final int OFFSET_FORMAT_VERSION_NUMBER_IN_MAGIC_SEQUENCE = 4;
    private static final int LENGTH_FORMAT_VERSION_NUMBER_IN_MAGIC_SEQUENCE = 3;
    protected static final int FILE_SIZE_OFFSET = 32;
    protected static final int HEADER_NOMINAL_SIZE = 112;
    protected static final int STANDARD_ENDIAN_VALUE = 305419896;
    protected static final int REVERSE_ENDIAN_VALUE = 2018915346;
    public long adler32Checksum;
    public byte[] signature = new byte[20];
    protected boolean isStandardEndian;
    public byte[] formatVersionNumber = new byte[3];
    public int linkTableSize;
    protected int stringIdsSize;
    protected int stringIdsOffset;
    protected int typeIdsSize;
    protected int typeIdsOffset;
    protected int protoIdsSize;
    protected int protoIdsOffset;
    protected int fieldIdsSize;
    protected int fieldIdsOffset;
    protected int methodIdsSize;
    protected int methodIdsOffset;
    protected int classDefinitionsSize;
    protected int classDefinitionsOffset;
    protected String[] constantPoolStrings;
    protected String[] constantPoolTypes;
    public static final int CLASS_DEF_ITEM_SIZE = 32;
    public static final int FIELD_ID_ITEM_SIZE = 8;
    public static final int STRING_ID_ITEM_SIZE = 4;
    public static final int TYPE_ID_ITEM_SIZE = 4;
    public static final int METHOD_ID_ITEM_SIZE = 8;
    public static final int PROTO_ID_ITEM_SIZE = 12;

    public void parse(byte[] dexBytes) throws IllegalArgumentException, IOException {
        this.reader = new DalvikValueReader(dexBytes, 32);
        this.readHeader();
        this.readStrings();
        this.readTypes();
    }

    protected void readHeader() throws IllegalArgumentException {
        this.reader.bytes(this.magic);
        if (!Arrays.equals(this.magic, MAGIC_TEMPLATE)) {
            throw new IllegalArgumentException("Unknown bytecode version");
        }
        for (int i = 0; i < this.formatVersionNumber.length; ++i) {
            this.formatVersionNumber[i] = this.magic[i + 4];
        }
        this.adler32Checksum = this.reader.uint();
        this.reader.bytes(this.signature);
        this.reader.skipInt();
        int header_size = this.reader.sint();
        if (header_size != 112) {
            throw new IllegalArgumentException("Bad header size: " + Integer.toHexString(header_size));
        }
        int endianTag = this.reader.sint();
        if (endianTag == 305419896) {
            this.isStandardEndian = true;
        } else if (endianTag == 2018915346) {
            this.isStandardEndian = false;
        } else {
            throw new IllegalArgumentException("Unknown Endian Value.");
        }
        this.linkTableSize = this.reader.sint();
        this.reader.skipInt();
        this.reader.skipInt();
        this.stringIdsSize = this.reader.sint();
        this.stringIdsOffset = this.reader.sint();
        this.typeIdsSize = this.reader.sint();
        this.typeIdsOffset = this.reader.sint();
        this.protoIdsSize = this.reader.sint();
        this.protoIdsOffset = this.reader.sint();
        this.fieldIdsSize = this.reader.sint();
        this.fieldIdsOffset = this.reader.sint();
        this.methodIdsSize = this.reader.sint();
        this.methodIdsOffset = this.reader.sint();
        this.classDefinitionsSize = this.reader.sint();
        this.classDefinitionsOffset = this.reader.sint();
        this.reader.skipInt();
        this.reader.skipInt();
    }

    protected void readStrings() {
        int i;
        this.reader.seek(this.stringIdsOffset);
        int[] stringOffsets = new int[this.stringIdsSize];
        for (i = 0; i < this.stringIdsSize; ++i) {
            stringOffsets[i] = this.reader.sint();
        }
        this.constantPoolStrings = new String[this.stringIdsSize];
        for (i = 0; i < this.stringIdsSize; ++i) {
            String string;
            this.reader.seek(stringOffsets[i]);
            int size = this.reader.uleb128();
            this.constantPoolStrings[i] = string = this.reader.utf8String();
            if (string.length() == size) continue;
            StringBuilder b = new StringBuilder();
            for (int k = stringOffsets[i]; k < this.reader.getPos(); ++k) {
                b.append(" ").append(Integer.toHexString(this.reader.peek(k)));
            }
            System.out.println("Mismatched size for string " + string + " " + size + " / " + string.length() + b);
        }
    }

    protected void readTypes() {
        this.constantPoolTypes = new String[this.typeIdsSize];
        for (int i = 0; i < this.typeIdsSize; ++i) {
            this.reader.seek(this.getOffsetTypeIdItem(i));
            int index = this.reader.uint();
            this.constantPoolTypes[i] = this.constantPoolStrings[index];
        }
    }

    public int getOffsetFieldIdItem(int itemIndex) {
        return this.fieldIdsOffset + itemIndex * 8;
    }

    public int getOffsetStringIdItem(int itemIndex) {
        return this.stringIdsOffset + itemIndex * 4;
    }

    public int getOffsetTypeIdItem(int itemIndex) {
        return this.typeIdsOffset + itemIndex * 4;
    }

    public int getOffsetMethodIdItem(int itemIndex) {
        return this.methodIdsOffset + itemIndex * 8;
    }

    public int getOffsetProtoIdItem(int itemIndex) {
        return this.protoIdsOffset + itemIndex * 12;
    }

    public int getClassDefinitionOffset(int itemIndex) {
        return this.classDefinitionsOffset + itemIndex * 32;
    }

    public boolean isStandardEndian() {
        return this.isStandardEndian;
    }

    public int getStringIdsSize() {
        return this.stringIdsSize;
    }

    public int getStringIdsOffset() {
        return this.stringIdsOffset;
    }

    public int getTypeIdsSize() {
        return this.typeIdsSize;
    }

    public int getTypeIdsOffset() {
        return this.typeIdsOffset;
    }

    public int getProtoIdsSize() {
        return this.protoIdsSize;
    }

    public int getProtoIdsOffset() {
        return this.protoIdsOffset;
    }

    public int getFieldIdsSize() {
        return this.fieldIdsSize;
    }

    public int getFieldIdsOffset() {
        return this.fieldIdsOffset;
    }

    public int getMethodIdsSize() {
        return this.methodIdsSize;
    }

    public int getMethodIdsOffset() {
        return this.methodIdsOffset;
    }

    public int getClassDefinitionsSize() {
        return this.classDefinitionsSize;
    }

    public int getClassDefinitionsOffset() {
        return this.classDefinitionsOffset;
    }

    public byte[] getFormatVersionNumber() {
        return this.formatVersionNumber;
    }
}

