/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction;

import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.IThreeRegistersInstruction;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.Instruction;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.lowLevelUtils.ByteVector;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.lowLevelUtils.IDalvikValueReader;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.structureWriter.ConstantPool;

public class InstructionFormat23X
extends Instruction
implements IThreeRegistersInstruction {
    private static final int INSTRUCTION_SIZE = 4;
    private int registerA;
    private int registerB;
    private int registerC;

    @Override
    public int getRegisterA() {
        return this.registerA;
    }

    @Override
    public int getRegisterB() {
        return this.registerB;
    }

    @Override
    public int getRegisterC() {
        return this.registerC;
    }

    public static int getRegisterA(int opcode) {
        return opcode >> 8 & 0xFF;
    }

    public static int getEncodedRegisterBAndC(IDalvikValueReader reader) {
        return reader.ushort();
    }

    public static int getRegisterBFromEncodedRegisterBAndC(int encodedRegisterBAndC) {
        return encodedRegisterBAndC & 0xFF;
    }

    public static int getRegisterCFromEncodedRegisterBAndC(int encodedRegisterBAndC) {
        return encodedRegisterBAndC >> 8 & 0xFF;
    }

    public static void skip(IDalvikValueReader reader) {
        reader.relativeSeek(2);
    }

    public InstructionFormat23X(int opcode, int registerA, int registerB, int registerC) {
        super(opcode);
        this.registerA = registerA;
        this.registerB = registerB;
        this.registerC = registerC;
    }

    @Override
    public int getSize() {
        return 4;
    }

    @Override
    public void write(ByteVector out, ConstantPool constantPool) {
        InstructionFormat23X.test8BitsLimit(this.registerA | this.registerB | this.registerC);
        out.putShort(((this.registerA & 0xFF) << 8) + this.opcodeByte);
        out.putShort(((this.registerC & 0xFF) << 8) + (this.registerB & 0xFF));
    }
}

