/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.encodedValue;

import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.encodedValue.EncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.encodedValue.EncodedValueUtil;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.structureWriter.ConstantPool;

public class EncodedValueFloat
extends EncodedValue {
    private int type = 16;
    private float value;

    public EncodedValueFloat(float value) {
        this.value = value;
    }

    public EncodedValueFloat(Object value) {
        this.value = ((Float)value).floatValue();
    }

    @Override
    public byte[] encode(ConstantPool constantPool) {
        return EncodedValueUtil.encodeZeroExtendedToRightValue((long)Float.floatToRawIntBits(Float.valueOf(this.value).floatValue()) << 32, this.type);
    }

    @Override
    public int getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        boolean result = false;
        if (o instanceof EncodedValueFloat) {
            EncodedValueFloat encodedValue = (EncodedValueFloat)o;
            result = this.type == encodedValue.type && this.value == encodedValue.value;
        }
        return result;
    }

    public int hashCode() {
        return this.type + (int)this.value * 1579;
    }

    @Override
    int compareValue(EncodedValue encodedValue) {
        if (this == encodedValue) {
            return 0;
        }
        EncodedValueFloat ef = (EncodedValueFloat)encodedValue;
        float value2 = ef.value;
        return this.value == value2 ? 0 : (this.value > value2 ? 1 : -1);
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

