/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex;

import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.ApplicationReader;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.ApplicationVisitor;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.ClassVisitor;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.ClassWriter;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.lowLevelUtils.ByteVector;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.lowLevelUtils.IDalvikValueReader;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.structureWriter.AnnotationDirectoryItem;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.structureWriter.AnnotationElement;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.structureWriter.AnnotationItem;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.structureWriter.AnnotationSetItem;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.structureWriter.AnnotationSetRefList;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.structureWriter.ClassDefinitionItem;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.structureWriter.CodeItem;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.structureWriter.ConstantPool;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.structureWriter.Field;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.structureWriter.IAnnotationsHolder;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.structureWriter.Method;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.structureWriter.Prototype;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.structureWriter.TypeList;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.zip.Adler32;

public class ApplicationWriter
extends ApplicationVisitor {
    private ConstantPool constantPool = new ConstantPool();
    private ByteVector out;
    private ApplicationReader applicationReader;
    public static final boolean DISPLAY_WRITER_INFORMATION = false;
    public static final boolean SKIP_DEBUG_INFO_ITEMS = false;
    private int stringIdsOffset = 112;
    private int typeIdsOffset;
    private int prototypeIdsOffset;
    private int fieldIdsOffset;
    private int methodIdsOffset;
    private int classDefinitionsOffset;
    private int dataOffset;
    private int annotationSetRefListOffset;
    private int annotationItemsOffset;
    private int annotationSetItemOffset;
    private int annotationDirectoryItemsOffset;
    private int encodedArrayItemsOffset;
    private int debugInfoItemOffset;
    private int typeListOffset;
    private int stringDataOffset;
    private int classDataItemOffset;
    private int codeItemOffset;
    private int debugInfoItemCount = 0;
    private int encodedArrayItemsCount = 0;
    private int classDataItemCount = 0;
    private int codeItemCount;
    private static final byte[] dexFileMagic = new byte[]{100, 101, 120, 10, 48, 51, 53, 0};
    private static final int ADLER_OFFSET = 8;
    private static final int ADLER_SIZE = 4;
    private static final int SHA1_SIGNATURE_OFFSET = 12;
    private static final int SHA1_SIGNATURE_SIZE = 20;
    private static final int HEADER_NOMINAL_SIZE = 112;
    private static final int STANDARD_ENDIAN_VALUE = 305419896;
    private static final int MAP_OFFSET_OFFSET = 52;
    private static final int FILE_SIZE_OFFSET = 32;
    private static final int STRING_ID_ITEM_SIZE = 4;
    private static final int TYPE_ID_ITEM_SIZE = 4;
    private static final int PROTO_ID_ITEM_SIZE = 12;
    private static final int FIELD_ID_ITEM_SIZE = 8;
    private static final int METHOD_ID_ITEM_SIZE = 8;
    private static final int CLASS_DEF_ITEM_SIZE = 32;

    public ApplicationWriter() {
        super(262144);
    }

    public ApplicationWriter(ApplicationReader applicationReader) {
        super(262144);
        applicationReader.copyPool(this);
        this.applicationReader = applicationReader;
    }

    @Override
    public void visit() {
    }

    @Override
    public ClassVisitor visitClass(int access, String name, String[] signature, String superName, String[] interfaces) {
        return new ClassWriter(this, this.constantPool, access, name, signature, superName, interfaces);
    }

    @Override
    public void visitEnd() {
        this.generateDexFile();
    }

    public byte[] toByteArray() {
        if (this.out == null) {
            return null;
        }
        return this.out.getData();
    }

    public ConstantPool getConstantPool() {
        return this.constantPool;
    }

    private void generateDexFile() {
        int nameIndex;
        this.out = new ByteVector(112);
        this.constantPool.prepareGeneration();
        this.out.putByteArray(dexFileMagic, 0, dexFileMagic.length);
        this.out.putInt(0);
        for (int i = 0; i < 20; ++i) {
            this.out.putByte(0);
        }
        this.out.putInt(0);
        this.out.putInt(112);
        this.out.putInt(305419896);
        this.out.putInt(0);
        this.out.putInt(0);
        this.out.putInt(0);
        this.stringIdsOffset = 112;
        int nbStrings = this.constantPool.getStringCount();
        this.out.putInt(nbStrings);
        this.out.putInt(nbStrings == 0 ? 0 : this.stringIdsOffset);
        int stringIdsSize = nbStrings * 4;
        this.typeIdsOffset = this.stringIdsOffset + stringIdsSize;
        int nbTypes = this.constantPool.getTypeCount();
        this.out.putInt(nbTypes);
        this.out.putInt(nbTypes == 0 ? 0 : this.typeIdsOffset);
        int typeIdsSize = nbTypes * 4;
        this.prototypeIdsOffset = this.typeIdsOffset + typeIdsSize;
        int nbProtos = this.constantPool.getPrototypeCount();
        this.out.putInt(nbProtos);
        this.out.putInt(nbProtos == 0 ? 0 : this.prototypeIdsOffset);
        int protoIdsSize = nbProtos * 12;
        this.fieldIdsOffset = this.prototypeIdsOffset + protoIdsSize;
        int nbFields = this.constantPool.getFieldCount();
        this.out.putInt(nbFields);
        this.out.putInt(nbFields == 0 ? 0 : this.fieldIdsOffset);
        int fieldIdsSize = nbFields * 8;
        this.methodIdsOffset = this.fieldIdsOffset + fieldIdsSize;
        int nbMethods = this.constantPool.getMethodCount();
        this.out.putInt(nbMethods);
        this.out.putInt(nbMethods == 0 ? 0 : this.methodIdsOffset);
        int methodIdsSize = nbMethods * 8;
        this.classDefinitionsOffset = this.methodIdsOffset + methodIdsSize;
        int nbClasses = this.constantPool.getClassDefinitionCount();
        this.out.putInt(nbClasses);
        this.out.putInt(nbClasses == 0 ? 0 : this.classDefinitionsOffset);
        int dataSizeOffset = this.out.getLength();
        this.out.putInt(0);
        this.out.putInt(0);
        for (int i = 0; i < nbStrings; ++i) {
            this.out.putInt(0);
        }
        for (String type : this.constantPool.getTypes()) {
            int index = this.constantPool.getStringIndex(type);
            this.out.putInt(index);
        }
        for (int i = 0; i < nbProtos; ++i) {
            this.out.putInt(0);
            this.out.putInt(0);
            this.out.putInt(0);
        }
        for (Field field : this.constantPool.getFields()) {
            String className = field.getClassName();
            String typeName = field.getTypeName();
            int classNameIndex = this.constantPool.getTypeIndex(className);
            int typeNameIndex = this.constantPool.getTypeIndex(typeName);
            nameIndex = this.constantPool.getStringIndex(field.getFieldName());
            this.out.putShort(classNameIndex);
            this.out.putShort(typeNameIndex);
            this.out.putInt(nameIndex);
        }
        for (Method method : this.constantPool.getMethods()) {
            String className = method.getClassName();
            Prototype prototype = method.getPrototype();
            String name = method.getMethodName();
            int classNameIndex = this.constantPool.getTypeIndex(className);
            nameIndex = this.constantPool.getStringIndex(name);
            int prototypeIndex = this.constantPool.getPrototypeIndex(prototype);
            this.out.putShort(classNameIndex);
            this.out.putShort(prototypeIndex);
            this.out.putInt(nameIndex);
        }
        for (int i = 0; i < nbClasses; ++i) {
            this.out.putInt(0);
            this.out.putInt(0);
            this.out.putInt(0);
            this.out.putInt(0);
            this.out.putInt(0);
            this.out.putInt(0);
            this.out.putInt(0);
            this.out.putInt(0);
        }
        this.dataOffset = this.out.getLength();
        this.prepareAnnotationSetRefLists();
        this.prepareAnnotationSetItems();
        this.writeCodeItems();
        this.prepareAnnotationDirectoryItems();
        this.writeTypeList();
        this.writePrototypeIds();
        this.writeStringDataItemSection();
        this.writeDebugInfoItems();
        this.writeAnnotationItems();
        this.completeAnnotationSetItems();
        this.completeAnnotationSetRefLists();
        this.completeAnnotationDirectoryItems();
        this.writeEncodedArrayItems();
        this.writeClassDataItems();
        this.writeMap();
        int dataSize = this.out.getLength() - this.dataOffset;
        if (dataSize % 4 != 0) {
            try {
                throw new Exception("Data Size isn't a multiple of (uint).");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.out.putInt(dataSize, dataSizeOffset);
        this.out.putInt(this.dataOffset, dataSizeOffset + 4);
        this.out.putInt(this.out.getLength(), 32);
        this.addSHA1Signature();
        this.addAdler32Checksum();
    }

    private void addAdler32Checksum() {
        Adler32 adler = new Adler32();
        adler.update(this.out.getBuffer(), 12, this.out.getLength() - 12);
        this.out.putInt((int)adler.getValue(), 8);
    }

    private void addSHA1Signature() {
        MessageDigest sha = null;
        try {
            sha = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        if (sha != null) {
            int sha1PostSignatureOffset = 32;
            sha.update(this.out.getBuffer(), sha1PostSignatureOffset, this.out.getLength() - sha1PostSignatureOffset);
            byte[] digest = sha.digest();
            if (digest.length == 20) {
                this.out.putByteArray(digest, 12);
            } else {
                try {
                    throw new Exception("SHA-1 digest has an unexpected size : " + digest.length);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void prepareAnnotationSetRefLists() {
        for (AnnotationSetRefList annotationSetRefList : this.constantPool.getAnnotationSetRefLists()) {
            this.out.addPadding();
            if (this.annotationSetRefListOffset == 0) {
                this.annotationSetRefListOffset = this.out.getLength();
            }
            this.constantPool.setAnnotationSetRefListOffset(annotationSetRefList, this.out.getLength());
            this.out.putInt(0);
            int size = annotationSetRefList.getNbAnnotationSetItem();
            for (int i = 0; i < size; ++i) {
                this.out.putInt(0);
            }
        }
    }

    private void prepareAnnotationSetItems() {
        for (AnnotationSetItem annotationSetItem : this.constantPool.getAnnotationSetItems()) {
            int size = annotationSetItem.getNbAnnotationItems();
            this.out.addPadding();
            if (this.annotationSetItemOffset == 0) {
                this.annotationSetItemOffset = this.out.getLength();
            }
            this.constantPool.setAnnotationSetItemOffset(annotationSetItem, this.out.getLength());
            this.out.putInt(0);
            for (int i = 0; i < size; ++i) {
                this.out.putInt(0);
            }
        }
    }

    private void writeCodeItems() {
        for (ClassDefinitionItem cdi : this.constantPool.getClasses()) {
            this.writeMethodsOfCodeItem(cdi.getDirectMethods());
            this.writeMethodsOfCodeItem(cdi.getVirtualMethods());
        }
    }

    private void writeMethodsOfCodeItem(List<Method> methods) {
        for (Method method : methods) {
            int startByteCodeToCopy;
            if (!method.supportsCodeItem()) continue;
            this.out.addPadding();
            if (this.codeItemOffset == 0) {
                this.codeItemOffset = this.out.getLength();
            }
            if ((startByteCodeToCopy = method.getStartBytecodeToCopy()) == 0) {
                ByteVector code = method.getCodeItemCode();
                if (code.getLength() > 0) {
                    CodeItem codeItem = method.getCodeItem();
                    codeItem.setOffset(this.out.getLength());
                    codeItem.mapResolvedIndexes();
                    this.out.putByteVector(code);
                    ByteVector tryCatchCode = codeItem.getCodeItemTryCatch();
                    if (tryCatchCode != null) {
                        this.out.putByteVector(tryCatchCode);
                    }
                }
            } else {
                CodeItem codeItem = method.getCodeItem();
                int outputFileByteCodeOffset = this.out.getLength();
                codeItem.setOffset(outputFileByteCodeOffset);
                IDalvikValueReader dexFile = this.applicationReader.getDexFile();
                int lengthByteCode = 16;
                dexFile.seek(startByteCodeToCopy + 6);
                int nbTries = dexFile.ushort();
                int startDebugInfoItem = dexFile.uint();
                method.setStartDebugInfoToCopy(startDebugInfoItem);
                int insnsSizeInWord = dexFile.uint();
                lengthByteCode += insnsSizeInWord * 2;
                if (nbTries != 0 && insnsSizeInWord % 2 != 0) {
                    lengthByteCode += 2;
                }
                this.out.putByteArray(dexFile.getContents(), startByteCodeToCopy, lengthByteCode);
                codeItem.mapResolvedIndexesByteCode(this.out, outputFileByteCodeOffset);
                if (nbTries != 0) {
                    ByteVector inputDexFileByteArray = new ByteVector(dexFile.getContents());
                    ByteVector tryCatch = codeItem.mapResolvedIndexesTryCatch(inputDexFileByteArray, startByteCodeToCopy + lengthByteCode, nbTries);
                    this.out.putByteVector(tryCatch);
                }
            }
            ++this.codeItemCount;
        }
    }

    private void prepareAnnotationDirectoryItems() {
        for (AnnotationDirectoryItem adi : this.constantPool.getAnnotationDirectoryItems()) {
            this.out.addPadding();
            if (this.annotationDirectoryItemsOffset == 0) {
                this.annotationDirectoryItemsOffset = this.out.getLength();
            }
            this.constantPool.setAnnotationDirectoryItemOffset(adi, this.out.getLength());
            this.out.putInt(0);
            int nbAnnotatedFields = adi.getNbAnnotatedFields();
            int nbAnnotatedMethods = adi.getNbAnnotatedMethods();
            int nbAnnotatedParameters = adi.getNbAnnotatedParameters();
            this.out.putInt(0);
            this.out.putInt(0);
            this.out.putInt(0);
            int size = nbAnnotatedFields + nbAnnotatedMethods + nbAnnotatedParameters;
            for (int i = 0; i < size; ++i) {
                this.out.putInt(0);
                this.out.putInt(0);
            }
        }
    }

    private void writeTypeList() {
        for (TypeList typeList : this.constantPool.getTypeList()) {
            this.out.addPadding();
            if (this.typeListOffset == 0) {
                this.typeListOffset = this.out.getLength();
            }
            this.constantPool.setTypeListOffset(typeList, this.out.getLength());
            int size = typeList.size();
            if (size <= 0) continue;
            this.out.putInt(size);
            for (String type : typeList.getTypeList()) {
                this.out.putShort(this.constantPool.getTypeIndex(type));
            }
        }
    }

    private void writePrototypeIds() {
        int prototypeIdsOffset = this.prototypeIdsOffset;
        for (Prototype prototype : this.constantPool.getPrototypes()) {
            String shortyDescriptor = prototype.getShortyDescriptor();
            this.out.putInt(this.constantPool.getStringIndex(shortyDescriptor), prototypeIdsOffset);
            String returnType = prototype.getReturnType();
            this.out.putInt(this.constantPool.getTypeIndex(returnType), prototypeIdsOffset += 4);
            TypeList typeList = prototype.getParameterTypes();
            int typeListOffset = typeList.size() == 0 ? 0 : this.constantPool.getTypeListOffset(typeList);
            this.out.putInt(typeListOffset, prototypeIdsOffset += 4);
            prototypeIdsOffset += 4;
        }
    }

    private void writeStringDataItemSection() {
        if (this.constantPool.getStringCount() > 0) {
            int stringIdsOffset = this.stringIdsOffset;
            this.stringDataOffset = this.out.getLength();
            for (String string : this.constantPool.getStrings()) {
                this.out.putInt(this.out.getLength(), stringIdsOffset);
                stringIdsOffset += 4;
                this.out.putUleb128(string.length());
                this.out.putMUTF8(string);
            }
        }
    }

    private void writeDebugInfoItems() {
        for (Method method : this.constantPool.getMethods()) {
            if (method.isUnknown() || !method.supportsCodeItem()) continue;
            CodeItem codeItem = method.getCodeItem();
            int startDebugInfoToCopy = method.getStartDebugInfoToCopy();
            if (startDebugInfoToCopy == 0) {
                ByteVector debugInfoItemCode = codeItem.getDebugInfoItemCode();
                if (debugInfoItemCode == null) continue;
                int currentDebugInfoItemOffset = this.out.getLength();
                int currentCodeItemOffset = codeItem.getOffset();
                if (currentCodeItemOffset == 0) continue;
                if (this.debugInfoItemOffset == 0) {
                    this.debugInfoItemOffset = currentDebugInfoItemOffset;
                }
                codeItem.setDebugInfoItemOffset(this.out, currentDebugInfoItemOffset);
                if (codeItem.areSymbolicIndexesUsedInDebugCodeItem()) {
                    debugInfoItemCode = codeItem.mapResolvedIndexesForDebug(debugInfoItemCode, 0);
                }
                this.out.putByteVector(debugInfoItemCode);
                ++this.debugInfoItemCount;
                continue;
            }
            IDalvikValueReader dexFile = this.applicationReader.getDexFile();
            ByteVector inputDexFileByteArray = new ByteVector(dexFile.getContents());
            int currentDebugInfoItemOffset = this.out.getLength();
            if (this.debugInfoItemOffset == 0) {
                this.debugInfoItemOffset = currentDebugInfoItemOffset;
            }
            ByteVector debugInfoItem = codeItem.mapResolvedIndexesForDebug(inputDexFileByteArray, startDebugInfoToCopy);
            this.out.putByteVector(debugInfoItem);
            codeItem.setDebugInfoItemOffset(this.out, currentDebugInfoItemOffset);
            ++this.debugInfoItemCount;
        }
    }

    private void writeAnnotationItems() {
        this.annotationItemsOffset = this.out.getLength();
        for (AnnotationItem annotationItem : this.constantPool.getAnnotationItems()) {
            this.constantPool.setAnnotationItemOffset(annotationItem, this.out.getLength());
            this.out.putByte(annotationItem.getVisibility());
            this.out.putUleb128(this.constantPool.getTypeIndex(annotationItem.getAnnotationType()));
            this.out.putUleb128(annotationItem.getNbAnnotationElements());
            PriorityQueue<AnnotationElement> annotationElements = annotationItem.getAnnotationElements();
            for (AnnotationElement annotationElement : annotationElements) {
                this.out.putUleb128(this.constantPool.getStringIndex(annotationElement.getElementName()));
                this.out.putByteArray(annotationElement.getEncodedValue().encode(this.constantPool));
            }
        }
    }

    private void completeAnnotationSetItems() {
        if (this.annotationSetItemOffset != 0 && this.constantPool.getAnnotationSetItemCount() > 0) {
            int offset = this.annotationSetItemOffset;
            for (AnnotationSetItem annotationSetItem : this.constantPool.getAnnotationSetItems()) {
                this.out.putInt(annotationSetItem.getNbAnnotationItems(), offset);
                offset += 4;
                for (AnnotationItem annotationItem : annotationSetItem.getAnnotationItems()) {
                    this.out.putInt(this.constantPool.getAnnotationItemOffset(annotationItem), offset);
                    offset += 4;
                }
            }
        }
    }

    private void completeAnnotationSetRefLists() {
        int offset = this.annotationSetRefListOffset;
        for (AnnotationSetRefList annotationSetRefList : this.constantPool.getAnnotationSetRefLists()) {
            int size = annotationSetRefList.getNbAnnotationSetItem();
            this.out.putInt(size, offset);
            offset += 4;
            for (int i = 0; i < size; ++i) {
                AnnotationSetItem annotationSetItem = annotationSetRefList.getAnnotationSetItem(i);
                this.out.putInt(this.constantPool.getAnnotationSetItemOffset(annotationSetItem), offset);
                offset += 4;
            }
        }
    }

    private void completeAnnotationDirectoryItems() {
        for (AnnotationDirectoryItem adi : this.constantPool.getAnnotationDirectoryItems()) {
            int directoryItemOffset = this.constantPool.getAnnotationDirectoryItemOffset(adi);
            if (directoryItemOffset == 0) continue;
            AnnotationSetItem annotationSetItem = adi.getClassAnnotationSetItem();
            if (annotationSetItem.getNbAnnotationItems() > 0) {
                int annotationOffset = this.constantPool.getAnnotationSetItemOffset(annotationSetItem);
                this.out.putInt(annotationOffset, directoryItemOffset);
            }
            this.out.putInt(adi.getNbAnnotatedFields(), directoryItemOffset + 4);
            this.out.putInt(adi.getNbAnnotatedMethods(), directoryItemOffset + 8);
            this.out.putInt(adi.getNbAnnotatedParameters(), directoryItemOffset + 12);
            directoryItemOffset += 16;
            if (adi.getNbAnnotatedFields() > 0) {
                TreeMap<Integer, Field> orderedContent = new TreeMap<Integer, Field>();
                for (Field field : adi.getAnnotatedFields()) {
                    orderedContent.put(this.constantPool.getFieldIndex(field), field);
                }
                for (Map.Entry entry : orderedContent.entrySet()) {
                    directoryItemOffset = this.writeFieldMethodIndexAnnotation((IAnnotationsHolder)entry.getValue(), (Integer)entry.getKey(), directoryItemOffset);
                }
            }
            if (adi.getNbAnnotatedMethods() > 0) {
                TreeMap<Integer, Method> orderedContent = new TreeMap<Integer, Method>();
                for (Method method : adi.getAnnotatedMethods()) {
                    orderedContent.put(this.constantPool.getMethodIndex(method), method);
                }
                for (Map.Entry entry : orderedContent.entrySet()) {
                    directoryItemOffset = this.writeFieldMethodIndexAnnotation((IAnnotationsHolder)entry.getValue(), (Integer)entry.getKey(), directoryItemOffset);
                }
            }
            if (adi.getNbAnnotatedParameters() <= 0) continue;
            TreeMap<Integer, AnnotationSetRefList> orderedContent = new TreeMap<Integer, AnnotationSetRefList>();
            for (AnnotationSetRefList annotationSetRefList : adi.getAnnotatedParameters()) {
                Method method = annotationSetRefList.getMethod();
                orderedContent.put(this.constantPool.getMethodIndex(method), method.getAnnotatedParameterSetRefList());
            }
            for (Map.Entry entry : orderedContent.entrySet()) {
                this.out.putInt((Integer)entry.getKey(), directoryItemOffset);
                this.out.putInt(this.constantPool.getAnnotationSetRefListOffset((AnnotationSetRefList)entry.getValue()), directoryItemOffset + 4);
                directoryItemOffset += 8;
            }
        }
    }

    private int writeFieldMethodIndexAnnotation(IAnnotationsHolder annotationsHolder, int index, int offset) {
        if (annotationsHolder.getNbAnnotations() > 0) {
            this.out.putInt(index, offset);
            this.out.putInt(this.constantPool.getAnnotationSetItemOffset(annotationsHolder.getAnnotationSetItem()), offset + 4);
            return offset + 8;
        }
        return offset;
    }

    private void writeEncodedArrayItems() {
        this.encodedArrayItemsOffset = this.out.getLength();
        class Place {
            public int offset;
            public int size;

            public Place(int offset, int size) {
                this.offset = offset;
                this.size = size;
            }
        }
        ArrayList<Place> places = new ArrayList<Place>();
        for (ClassDefinitionItem cdi : this.constantPool.getClasses()) {
            if (cdi.getNbStaticFields() <= 0) continue;
            ArrayList<Field> fields = cdi.getStaticFields();
            boolean found = false;
            int lastFinalStaticIndex = fields.size() - 1;
            while (!found && lastFinalStaticIndex >= 0) {
                Field field = fields.get(lastFinalStaticIndex);
                found = field.isFinalStatic() && field.getValue() != null && field.getValue().getType() != 30;
                if (found) continue;
                --lastFinalStaticIndex;
            }
            if (!found) continue;
            int possibleOffset = this.out.getLength();
            ByteVector bv = new ByteVector();
            bv.putUleb128(lastFinalStaticIndex + 1);
            for (int index = 0; index <= lastFinalStaticIndex; ++index) {
                byte[] bytes;
                Field field = fields.get(index);
                if (field.getValue() == null) {
                    field.setNoValue();
                }
                if ((bytes = field.encodeValue(this.constantPool)) == null) continue;
                bv.putByteArray(bytes);
            }
            boolean foundDuplicate = false;
            int size = places.size();
            int scannedStructureOffset = 0;
            for (int indexPlace = 0; !foundDuplicate && indexPlace < size; ++indexPlace) {
                byte[] bytesPending = bv.getBuffer();
                int bytesPendingSize = bv.getLength();
                Place currentPlace = (Place)places.get(indexPlace);
                int placeSize = currentPlace.size;
                if (placeSize != bytesPendingSize) continue;
                scannedStructureOffset = currentPlace.offset;
                boolean difference = false;
                for (int posPending = 0; !difference && posPending < placeSize; ++posPending) {
                    difference = bytesPending[posPending] != this.out.getBuffer()[scannedStructureOffset + posPending];
                }
                foundDuplicate = !difference;
            }
            if (!foundDuplicate) {
                ++this.encodedArrayItemsCount;
                places.add(new Place(possibleOffset, bv.getLength()));
                this.out.putByteVector(bv);
            } else {
                possibleOffset = scannedStructureOffset;
            }
            this.constantPool.addOffsetForStaticValuesEncodedArrayItemOfClass(cdi, possibleOffset);
        }
    }

    private void writeClassDataItems() {
        int currentClassDefinitionOffset = this.classDefinitionsOffset;
        this.classDataItemOffset = this.out.getLength();
        for (ClassDefinitionItem cdi : this.constantPool.getClasses()) {
            this.out.putInt(this.constantPool.getTypeIndex(cdi.getClassName()), currentClassDefinitionOffset);
            this.out.putInt(cdi.getAccessFlags(), currentClassDefinitionOffset + 4);
            String superClassName = cdi.getSuperClassName();
            int superClassIndex = superClassName == null ? -1 : this.constantPool.getTypeIndex(superClassName);
            this.out.putInt(superClassIndex, currentClassDefinitionOffset + 8);
            TypeList interfaces = cdi.getInterfaces();
            int indexTypeListInterface = interfaces.size() == 0 ? 0 : this.constantPool.getTypeListOffset(interfaces);
            this.out.putInt(indexTypeListInterface, currentClassDefinitionOffset + 12);
            String sourceFile = cdi.getSourceFileName();
            int indexSourceFile = sourceFile == null ? -1 : this.constantPool.getStringIndex(sourceFile);
            this.out.putInt(indexSourceFile, currentClassDefinitionOffset + 16);
            this.out.putInt(this.constantPool.getAnnotationDirectoryItemOffset(cdi.getAnnotationDirectoryItem()), currentClassDefinitionOffset + 20);
            int classDataOffset = cdi.isInterface() && cdi.getNbStaticFields() == 0 && cdi.getNbInstanceFields() == 0 && cdi.getNbDirectMethods() == 0 && cdi.getNbVirtualMethods() == 0 ? 0 : this.out.getLength();
            this.out.putInt(classDataOffset, currentClassDefinitionOffset + 24);
            this.out.putInt(this.constantPool.getOffsetOfStaticValuesEncodedArrayItemOfClass(cdi), currentClassDefinitionOffset + 28);
            currentClassDefinitionOffset += 32;
            if (classDataOffset == 0) continue;
            this.out.putUleb128(cdi.getNbStaticFields());
            this.out.putUleb128(cdi.getNbInstanceFields());
            this.out.putUleb128(cdi.getNbDirectMethods());
            this.out.putUleb128(cdi.getNbVirtualMethods());
            this.writeFieldsInClassDataItem(cdi.getStaticFields());
            this.writeFieldsInClassDataItem(cdi.getInstanceFields());
            this.writeMethodsInClassDataItem(cdi.getDirectMethods());
            this.writeMethodsInClassDataItem(cdi.getVirtualMethods());
            ++this.classDataItemCount;
        }
    }

    private void writeMethodsInClassDataItem(ArrayList<Method> methods) {
        if (methods.size() == 0) {
            return;
        }
        TreeSet<Method> sortedMethods = new TreeSet<Method>(methods);
        boolean isFirstMethod = true;
        int previousIndex = 0;
        int indexToEncode = 0;
        for (Method method : sortedMethods) {
            int methodIndex = this.constantPool.getMethodIndex(method);
            if (isFirstMethod) {
                indexToEncode = methodIndex;
                isFirstMethod = false;
            } else {
                indexToEncode = methodIndex - previousIndex;
            }
            this.out.putUleb128(indexToEncode);
            this.out.putUleb128(method.getAccess());
            CodeItem codeItem = method.getCodeItem();
            this.out.putUleb128(codeItem == null ? 0 : codeItem.getOffset());
            previousIndex = methodIndex;
        }
    }

    private void writeFieldsInClassDataItem(ArrayList<Field> fields) {
        if (fields.size() == 0) {
            return;
        }
        TreeSet<Field> sortedFields = new TreeSet<Field>(fields);
        boolean isFirstField = true;
        int previousIndex = 0;
        int indexToEncode = 0;
        for (Field field : sortedFields) {
            int fieldIndex = this.constantPool.getFieldIndex(field);
            if (isFirstField) {
                indexToEncode = fieldIndex;
                isFirstField = false;
            } else {
                indexToEncode = fieldIndex - previousIndex;
            }
            this.out.putUleb128(indexToEncode);
            this.out.putUleb128(field.getAccess());
            previousIndex = fieldIndex;
        }
    }

    private void writeMap() {
        this.out.addPadding();
        int mapOffset = this.out.getLength();
        this.out.putInt(0);
        this.out.putInt(mapOffset, 52);
        int nbEntries = this.writeMapItem(0, 1, 0, 0);
        nbEntries = this.writeMapItem(1, this.constantPool.getStringCount(), this.stringIdsOffset, nbEntries);
        nbEntries = this.writeMapItem(2, this.constantPool.getTypeCount(), this.typeIdsOffset, nbEntries);
        nbEntries = this.writeMapItem(3, this.constantPool.getPrototypeCount(), this.prototypeIdsOffset, nbEntries);
        nbEntries = this.writeMapItem(4, this.constantPool.getFieldCount(), this.fieldIdsOffset, nbEntries);
        nbEntries = this.writeMapItem(5, this.constantPool.getMethodCount(), this.methodIdsOffset, nbEntries);
        nbEntries = this.writeMapItem(6, this.constantPool.getClassDefinitionCount(), this.classDefinitionsOffset, nbEntries);
        nbEntries = this.writeMapItem(4098, this.constantPool.getAnnotationSetRefListsCount(), this.annotationSetRefListOffset, nbEntries);
        nbEntries = this.writeMapItem(4099, this.constantPool.getAnnotationSetItemCount(), this.annotationSetItemOffset, nbEntries);
        nbEntries = this.writeMapItem(8193, this.codeItemCount, this.codeItemOffset, nbEntries);
        nbEntries = this.writeMapItem(8198, this.constantPool.getAnnotationDirectoryItemCount(), this.annotationDirectoryItemsOffset, nbEntries);
        nbEntries = this.writeMapItem(4097, this.constantPool.getTypeListCount(), this.typeListOffset, nbEntries);
        nbEntries = this.writeMapItem(8194, this.constantPool.getStringCount(), this.stringDataOffset, nbEntries);
        nbEntries = this.writeMapItem(8195, this.debugInfoItemCount, this.debugInfoItemOffset, nbEntries);
        nbEntries = this.writeMapItem(8196, this.constantPool.getAnnotationItemCount(), this.annotationItemsOffset, nbEntries);
        nbEntries = this.writeMapItem(8197, this.encodedArrayItemsCount, this.encodedArrayItemsOffset, nbEntries);
        nbEntries = this.writeMapItem(8192, this.classDataItemCount, this.classDataItemOffset, nbEntries);
        nbEntries = this.writeMapItem(4096, 1, mapOffset, nbEntries);
        this.out.putInt(nbEntries, mapOffset);
    }

    private int writeMapItem(int type, int size, int offset, int nbEntries) {
        if (size > 0) {
            this.out.putShort(type);
            this.out.putShort(0);
            this.out.putInt(size);
            this.out.putInt(offset);
            ++nbEntries;
        }
        return nbEntries;
    }

    public ApplicationReader getApplicationReader() {
        return this.applicationReader;
    }

    public void addStringFromApplicationReader(String string) {
        this.constantPool.addStringToConstantPool(string);
    }

    public void addTypeNameFromApplicationReader(String type) {
        this.constantPool.addTypeToConstantPool(type);
    }

    public void addFieldFromApplicationReader(String className, String type, String fieldName) {
        this.constantPool.addFieldToConstantPool(fieldName, type, className, 262144, null, null);
    }

    public void addMethodFromApplicationReader(String className, String prototype, String methodName) {
        this.constantPool.addMethodToConstantPool(methodName, className, prototype, 262144, null, null);
    }
}

