/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener;

import android.app.Instrumentation;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.support.annotation.NonNull;
import com.github.tmurakami.dexopener.AcceptAll;
import com.github.tmurakami.dexopener.ClassNameFilter;
import com.github.tmurakami.dexopener.ClassNameFilterWrapper;
import com.github.tmurakami.dexopener.DexClassFileFactory;
import com.github.tmurakami.dexopener.DexFileLoader;
import com.github.tmurakami.dexopener.DexOpenerImpl;

public abstract class DexOpener {
    DexOpener() {
    }

    public static void install(@NonNull Instrumentation instrumentation) {
        Context context = instrumentation.getTargetContext();
        if (context == null) {
            throw new IllegalArgumentException("'instrumentation' has not been initialized yet");
        }
        DexOpener.builder(context).build().installTo(context.getClassLoader());
    }

    @Deprecated
    public final void install(@NonNull ClassLoader classLoader) {
        this.installTo(classLoader);
    }

    public abstract void installTo(@NonNull ClassLoader var1);

    @NonNull
    public static Builder builder(@NonNull Context context) {
        return new Builder(context.getApplicationInfo());
    }

    public static final class Builder {
        private final ApplicationInfo applicationInfo;
        private ClassNameFilter classNameFilter = AcceptAll.INSTANCE;

        Builder(ApplicationInfo applicationInfo) {
            this.applicationInfo = applicationInfo;
        }

        @Deprecated
        @NonNull
        public Builder classNameFilters(ClassNameFilter ... filters) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Use openIf(ClassNameFilter) or classNameFilter(ClassNameFilter) instead");
        }

        @NonNull
        public Builder openIf(@NonNull ClassNameFilter filter) {
            return this.classNameFilter(filter);
        }

        @NonNull
        public Builder classNameFilter(@NonNull ClassNameFilter filter) {
            this.classNameFilter = filter;
            return this;
        }

        @NonNull
        public DexOpener build() {
            return new DexOpenerImpl(this.applicationInfo, new ClassNameFilterWrapper(this.classNameFilter), DexFileLoader.INSTANCE, DexClassFileFactory.INSTANCE);
        }
    }
}

