/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener;

import com.github.tmurakami.dexopener.ApplicationOpener;
import com.github.tmurakami.dexopener.DexFileLoader;
import com.github.tmurakami.dexopener.FileUtils;
import com.github.tmurakami.dexopener.TypeUtils;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.ApplicationReader;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.ApplicationVisitor;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.ApplicationWriter;
import dalvik.system.DexFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

final class DexFiles {
    private byte[] byteCode;
    private final Set<Set<String>> internalNamesSet;
    private final File cacheDir;
    private final DexFileLoader dexFileLoader;
    private final Map<String, DexFile> dexFileMap;

    DexFiles(byte[] byteCode, Set<Set<String>> internalNamesSet, File cacheDir, DexFileLoader dexFileLoader, Map<String, DexFile> dexFileMap) {
        this.byteCode = byteCode;
        this.internalNamesSet = internalNamesSet;
        this.cacheDir = cacheDir;
        this.dexFileLoader = dexFileLoader;
        this.dexFileMap = dexFileMap;
    }

    DexFile get(String className) throws IOException {
        byte[] openedByteCode;
        DexFile dexFile = this.dexFileMap.get(className);
        if (dexFile != null) {
            return dexFile;
        }
        byte[] byteCode = this.byteCode;
        if (byteCode == null) {
            return null;
        }
        String[] classesToVisit = DexFiles.getClassesToVisit(className, this.internalNamesSet);
        if (classesToVisit == null) {
            return null;
        }
        if (this.internalNamesSet.isEmpty()) {
            this.byteCode = null;
        }
        try {
            openedByteCode = DexFiles.openClasses(byteCode, classesToVisit);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error while processing the class '" + className + "'", e);
        }
        if (!this.cacheDir.isDirectory() && !this.cacheDir.mkdirs()) {
            throw new IllegalStateException("Cannot create " + this.cacheDir);
        }
        dexFile = DexFiles.loadDex(this.dexFileLoader, this.cacheDir, openedByteCode);
        Enumeration e = dexFile.entries();
        while (e.hasMoreElements()) {
            this.dexFileMap.put((String)e.nextElement(), dexFile);
        }
        return dexFile;
    }

    private static String[] getClassesToVisit(String className, Set<Set<String>> internalNamesSet) {
        String internalName = TypeUtils.getInternalName(className);
        Iterator<Set<String>> it = internalNamesSet.iterator();
        while (it.hasNext()) {
            Set<String> set = it.next();
            if (!set.contains(internalName)) continue;
            it.remove();
            return set.toArray(new String[set.size()]);
        }
        return null;
    }

    private static byte[] openClasses(byte[] byteCode, String[] classesToVisit) {
        ApplicationWriter aw = new ApplicationWriter();
        new ApplicationReader(262144, byteCode).accept((ApplicationVisitor)new ApplicationOpener((ApplicationVisitor)aw), classesToVisit, 0);
        return aw.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DexFile loadDex(DexFileLoader dexFileLoader, File cacheDir, byte[] byteCode) throws IOException {
        DexFile dexFile;
        File zip = File.createTempFile("classes", ".zip", cacheDir);
        try {
            try (ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zip));){
                out.putNextEntry(new ZipEntry("classes.dex"));
                out.write(byteCode);
            }
            String sourcePathName = zip.getCanonicalPath();
            dexFile = dexFileLoader.loadDex(sourcePathName, sourcePathName + ".dex", 0);
        }
        catch (Throwable throwable) {
            FileUtils.delete(zip);
            throw throwable;
        }
        FileUtils.delete(zip);
        return dexFile;
    }
}

