/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction;

import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.ILiteralInstruction;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.ITwoRegistersInstruction;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.Instruction;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.lowLevelUtils.ByteVector;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.lowLevelUtils.IDalvikValueReader;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.structureWriter.ConstantPool;

public class InstructionFormat22B
extends Instruction
implements ITwoRegistersInstruction,
ILiteralInstruction {
    private static final int INSTRUCTION_SIZE = 4;
    private int registerA;
    private int registerB;
    private int literalC;

    @Override
    public int getRegisterA() {
        return this.registerA;
    }

    @Override
    public int getRegisterB() {
        return this.registerB;
    }

    @Override
    public int getLiteral() {
        return this.literalC;
    }

    public static int getRegisterA(int opcode) {
        return opcode >> 8 & 0xFF;
    }

    public static int getEncodedRegisterBAndLiteralC(IDalvikValueReader reader) {
        return reader.ushort();
    }

    public static int getRegisterBFromEncodedRegisterBAndC(int encodedRegisterBAndLiteralC) {
        return encodedRegisterBAndLiteralC & 0xFF;
    }

    public static int getLiteralCFromEncodedRegisterBAndLiteralC(int encodedRegisterBAndC) {
        return (byte)(encodedRegisterBAndC >> 8);
    }

    public static void skip(IDalvikValueReader reader) {
        reader.relativeSeek(2);
    }

    public InstructionFormat22B(int opcode, int registerA, int registerB, int value) {
        super(opcode);
        this.registerA = registerA;
        this.registerB = registerB;
        this.literalC = value;
    }

    @Override
    public int getSize() {
        return 4;
    }

    @Override
    public void write(ByteVector out, ConstantPool constantPool) {
        InstructionFormat22B.test8BitsLimit(this.registerA | this.registerB);
        out.putShort(((this.registerA & 0xFF) << 8) + this.opcodeByte);
        out.putShort(((this.literalC & 0xFF) << 8) + (this.registerB & 0xFF));
    }
}

