/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction;

import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.ILiteralInstruction;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.IOneRegisterInstruction;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.instruction.Instruction;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.lowLevelUtils.ByteVector;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.structureWriter.ConstantPool;

public class InstructionFormat11N
extends Instruction
implements IOneRegisterInstruction,
ILiteralInstruction {
    private static final int INSTRUCTION_SIZE = 2;
    private int registerA;
    private int literalB;

    @Override
    public int getRegisterA() {
        return this.registerA;
    }

    @Override
    public int getLiteral() {
        return this.literalB;
    }

    public static int getRegisterA(int opcode) {
        return opcode >> 8 & 0xF;
    }

    public static int getLiteralB(int opcode) {
        return (byte)(opcode >> 8) >> 4;
    }

    public InstructionFormat11N(int opcode, int destinationRegister, int var) {
        super(opcode);
        this.registerA = destinationRegister;
        this.literalB = var;
        Instruction.test4BitsLimit(this.registerA);
        Instruction.test4BitsLimit(this.literalB);
    }

    @Override
    public int getSize() {
        return 2;
    }

    @Override
    public void write(ByteVector out, ConstantPool constantPool) {
        InstructionFormat11N.test4BitsLimit(this.registerA);
        int firstShort = ((this.literalB & 0xF) << 12) + ((this.registerA & 0xF) << 8) + this.opcodeByte;
        out.putShort(firstShort);
    }
}

