/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.encodedValue;

import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.encodedValue.EncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.encodedValue.EncodedValueUtil;
import com.github.tmurakami.dexopener.repackaged.org.ow2.asmdex.structureWriter.ConstantPool;

public class EncodedValueString
extends EncodedValue {
    private int type = 23;
    private String value;

    public EncodedValueString(String value) {
        if (value == null) {
            throw new RuntimeException("EncodedValue");
        }
        this.value = value;
    }

    @Override
    public byte[] encode(ConstantPool constantPool) {
        int index = constantPool.getStringIndex(this.value);
        return EncodedValueUtil.encodeUnsignedValue(index, this.type);
    }

    @Override
    public int getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        boolean result = false;
        if (o instanceof EncodedValueString) {
            EncodedValueString encodedValue = (EncodedValueString)o;
            result = this.type == encodedValue.type && this.value.equals(encodedValue.value);
        }
        return result;
    }

    public int hashCode() {
        return this.type + this.value.hashCode();
    }

    @Override
    int compareValue(EncodedValue encodedValue) {
        if (this == encodedValue) {
            return 0;
        }
        EncodedValueString ev = (EncodedValueString)encodedValue;
        return this.value.compareTo(ev.value);
    }

    public String toString() {
        return '\"' + this.value + '\"';
    }
}

