/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon.service;

import android.os.SystemClock;
import android.util.Log;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import org.altbeacon.beacon.Beacon;
import org.altbeacon.beacon.BeaconManager;
import org.altbeacon.beacon.service.RssiFilter;
import org.altbeacon.beacon.service.RunningAverageRssiFilter;

public class RangedBeacon
implements Serializable {
    private static final String TAG = "RangedBeacon";
    public static final long DEFAULT_MAX_TRACKING_AGE = 5000L;
    public static long maxTrackingAge = 5000L;
    public static final long DEFAULT_SAMPLE_EXPIRATION_MILLISECONDS = 20000L;
    private static long sampleExpirationMilliseconds = 20000L;
    private boolean mTracked = true;
    protected long lastTrackedTimeMillis = 0L;
    Beacon mBeacon;
    protected transient RssiFilter mFilter = null;
    private int packetCount = 0;

    public RangedBeacon(Beacon beacon) {
        this.updateBeacon(beacon);
    }

    public void updateBeacon(Beacon beacon) {
        ++this.packetCount;
        this.mBeacon = beacon;
        this.addMeasurement(this.mBeacon.getRssi());
    }

    public boolean isTracked() {
        return this.mTracked;
    }

    public void setTracked(boolean tracked) {
        this.mTracked = tracked;
    }

    public Beacon getBeacon() {
        return this.mBeacon;
    }

    public void commitMeasurements() {
        if (!this.getFilter().noMeasurementsAvailable()) {
            double runningAverage = this.getFilter().calculateRssi();
            this.mBeacon.getRssiMeasurementList().addAll(((RunningAverageRssiFilter)this.getFilter()).getMeasurements());
            this.mBeacon.setRunningAverageRssi(runningAverage);
            this.mBeacon.setRssiMeasurementCount(this.getFilter().getMeasurementCount());
        } else {
            Log.d((String)TAG, (String)"No measurements available to calculate running average");
        }
        this.mBeacon.setPacketCount(this.packetCount);
        this.packetCount = 0;
    }

    public void addMeasurement(Integer rssi) {
        if (rssi != 127) {
            this.mTracked = true;
            this.lastTrackedTimeMillis = SystemClock.elapsedRealtime();
            this.getFilter().addMeasurement(rssi);
        }
    }

    public static void setSampleExpirationMilliseconds(long milliseconds) {
        sampleExpirationMilliseconds = milliseconds;
        RunningAverageRssiFilter.setSampleExpirationMilliseconds(sampleExpirationMilliseconds);
    }

    public static void setMaxTrackingAge(int maxTrackinAge) {
        maxTrackingAge = maxTrackinAge;
    }

    public boolean noMeasurementsAvailable() {
        return this.getFilter().noMeasurementsAvailable();
    }

    public long getTrackingAge() {
        return SystemClock.elapsedRealtime() - this.lastTrackedTimeMillis;
    }

    public boolean isExpired() {
        return this.getTrackingAge() > maxTrackingAge;
    }

    private RssiFilter getFilter() {
        if (this.mFilter == null) {
            try {
                Constructor<?> cons = BeaconManager.getRssiFilterImplClass().getConstructors()[0];
                this.mFilter = (RssiFilter)cons.newInstance(new Object[0]);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)String.format("Could not construct RssiFilterImplClass %s", BeaconManager.getRssiFilterImplClass().getName()));
            }
        }
        return this.mFilter;
    }
}

