/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import androidx.annotation.NonNull;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import org.altbeacon.beacon.IntentHandler;
import org.altbeacon.beacon.logging.LogManager;

public class BeaconLocalBroadcastProcessor {
    private static final String TAG = "BeaconLocalBroadcastProcessor";
    public static final String RANGE_NOTIFICATION = "org.altbeacon.beacon.range_notification";
    public static final String MONITOR_NOTIFICATION = "org.altbeacon.beacon.monitor_notification";
    @NonNull
    private Context mContext;
    static int registerCallCount = 0;
    int registerCallCountForInstnace = 0;
    private BroadcastReceiver mLocalBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            new IntentHandler().convertIntentsToCallbacks(context, intent);
        }
    };

    private BeaconLocalBroadcastProcessor() {
    }

    public BeaconLocalBroadcastProcessor(Context context) {
        this.mContext = context;
    }

    public void register() {
        ++this.registerCallCountForInstnace;
        LogManager.d(TAG, "Register calls: global=" + ++registerCallCount + " instance=" + this.registerCallCountForInstnace, new Object[0]);
        this.unregister();
        LocalBroadcastManager.getInstance((Context)this.mContext).registerReceiver(this.mLocalBroadcastReceiver, new IntentFilter(RANGE_NOTIFICATION));
        LocalBroadcastManager.getInstance((Context)this.mContext).registerReceiver(this.mLocalBroadcastReceiver, new IntentFilter(MONITOR_NOTIFICATION));
    }

    public void unregister() {
        LocalBroadcastManager.getInstance((Context)this.mContext).unregisterReceiver(this.mLocalBroadcastReceiver);
    }
}

