/*
 * Decompiled with CFR 0.152.
 */
package com.tiagobagni.simplexmlserializerlib.xml;

import com.tiagobagni.simplexmlserializerlib.XmlSerializerLogger;
import com.tiagobagni.simplexmlserializerlib.xml.ReflectionUtils;
import com.tiagobagni.simplexmlserializerlib.xml.SimpleXmlParams;
import com.tiagobagni.simplexmlserializerlib.xml.annotation.XmlClass;
import com.tiagobagni.simplexmlserializerlib.xml.annotation.XmlField;
import com.tiagobagni.simplexmlserializerlib.xml.annotation.XmlObject;
import com.tiagobagni.simplexmlserializerlib.xml.annotation.XmlObjectList;
import com.tiagobagni.simplexmlserializerlib.xml.annotation.XmlObjects;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;

public class XmlSerializer {
    private static final String NEW_LINE = "\n";
    private static final String INDENTATION = "  ";
    private static final String XML_HEADER = "<?xml version=\"1.0\"?>";
    private StringBuilder xmlBuilder;
    private String spacing;
    private String nestedSpacing;
    private int indentLevels;
    private Object xmlObject;
    private String xmlRootTag;
    private XmlSerializer nestedSerializer;
    private final boolean DBG;
    private boolean indentOutput;
    private final XmlSerializerLogger LOGGER;

    public XmlSerializer() {
        SimpleXmlParams params = SimpleXmlParams.get();
        this.DBG = params.isDebugMode();
        this.LOGGER = params.getLogger();
        this.indentOutput = true;
    }

    public void setIndentOutput(boolean indentOutput) {
        this.indentOutput = indentOutput;
    }

    public String serialize(Object xmlObject) throws IllegalAccessException {
        this.initializeFor(xmlObject);
        this.writeXmlHeader();
        this.writeXmlBody(0);
        return this.xmlBuilder.toString();
    }

    private void initializeFor(Object xmlObject) {
        this.ensureValid(xmlObject);
        this.xmlObject = xmlObject;
        this.xmlRootTag = ReflectionUtils.getClassTag(xmlObject);
        this.xmlBuilder = new StringBuilder();
        this.nestedSerializer = null;
    }

    private void ensureValid(Object xmlObject) {
        if (xmlObject == null) {
            throw new NullPointerException("Trying to serialize a null object");
        }
        XmlClass annotation = xmlObject.getClass().getAnnotation(XmlClass.class);
        if (annotation == null) {
            throw new IllegalArgumentException("Invalid XmlClass. Missing Xml annotation");
        }
    }

    private void writeXmlHeader() {
        this.content(XML_HEADER);
        this.newLine();
        if (this.DBG) {
            this.LOGGER.debug("writing xml header");
        }
    }

    private void writeXmlBody(StringBuilder xmlBuilder, int indentLevels) throws IllegalAccessException {
        this.xmlBuilder = xmlBuilder;
        this.writeXmlBody(indentLevels);
    }

    private void writeXmlBody(int indentLevels) throws IllegalAccessException {
        this.setIndentation(indentLevels);
        this.writeOpenTag();
        this.writeFields();
        this.writeCloseTag();
    }

    private void setIndentation(int indentLevels) {
        this.indentLevels = indentLevels;
        this.spacing = this.getSpaces(indentLevels);
        this.nestedSpacing = this.getSpaces(indentLevels + 1);
    }

    private void writeOpenTag() {
        if (this.DBG) {
            this.LOGGER.debug("writing open tag: " + this.xmlRootTag);
        }
        this.indent(this.spacing);
        this.open(this.xmlRootTag);
        this.newLine();
    }

    private void writeFields() throws IllegalAccessException {
        Field[] fields;
        for (Field field : fields = this.getOrderedFields()) {
            Annotation annotation = ReflectionUtils.getFieldAnnotation(field);
            if (annotation == null) continue;
            field.setAccessible(true);
            Object value = field.get(this.xmlObject);
            String tag = ReflectionUtils.getFieldTag(field, annotation);
            if (annotation instanceof XmlField) {
                this.writeXmlField(tag, value);
            } else if (annotation instanceof XmlObject) {
                this.writeXmlObject(tag, value);
            } else if (annotation instanceof XmlObjectList) {
                this.writeXmlList(tag, (List)value);
            } else {
                if (!(annotation instanceof XmlObjects)) continue;
                this.writeMultipleItems(tag, (List)value);
            }
            this.newLine();
        }
    }

    private Field[] getOrderedFields() {
        Field[] fields = this.xmlObject.getClass().getDeclaredFields();
        Arrays.sort(fields, (first, second) -> {
            Annotation annotation1 = ReflectionUtils.getFieldAnnotation(first);
            Annotation annotation2 = ReflectionUtils.getFieldAnnotation(second);
            if (annotation1 instanceof XmlField) {
                return -1;
            }
            if (annotation2 instanceof XmlField) {
                return 1;
            }
            return 0;
        });
        return fields;
    }

    private void writeXmlField(String tag, Object value) {
        if (this.DBG) {
            this.LOGGER.debug("writing primitive: " + tag + " = " + value);
        }
        this.indent(this.nestedSpacing);
        this.open(tag);
        this.content(value == null ? "" : value);
        this.close(tag);
    }

    private void writeXmlObject(String tag, Object value) throws IllegalAccessException {
        if (this.DBG) {
            this.LOGGER.debug("writing object: " + tag + " = " + value);
        }
        if (value == null) {
            if (this.DBG) {
                this.LOGGER.debug("Skip object because it is null");
            }
            return;
        }
        if (this.nestedSerializer == null) {
            this.nestedSerializer = new XmlSerializer();
            this.nestedSerializer.setIndentOutput(this.indentOutput);
        }
        this.nestedSerializer.initializeFor(value);
        this.nestedSerializer.xmlRootTag = tag;
        this.nestedSerializer.writeXmlBody(this.xmlBuilder, this.indentLevels + 1);
    }

    private void writeXmlList(String tag, List items) throws IllegalAccessException {
        if (this.DBG) {
            this.LOGGER.debug("writing list: " + tag);
        }
        if (items == null) {
            if (this.DBG) {
                this.LOGGER.debug("Skip list because it is null");
            }
            return;
        }
        this.indent(this.nestedSpacing);
        this.open(tag);
        this.newLine();
        Class<?> itemType = items != null && items.size() > 0 ? items.get(0).getClass() : null;
        String itemTag = itemType != null ? itemType.getSimpleName() : "";
        ++this.indentLevels;
        this.writeMultipleItems(itemTag, items);
        --this.indentLevels;
        this.indent(this.nestedSpacing);
        this.close(tag);
    }

    private void writeMultipleItems(String tag, List items) throws IllegalAccessException {
        if (items == null) {
            if (this.DBG) {
                this.LOGGER.debug("Skip multiple objects because it is null");
            }
            return;
        }
        for (Object item : items) {
            this.writeXmlObject(tag, item);
            this.newLine();
        }
    }

    private void writeCloseTag() {
        if (this.DBG) {
            this.LOGGER.debug("writing close tag: " + this.xmlRootTag);
        }
        this.indent(this.spacing);
        this.close(this.xmlRootTag);
    }

    private void open(String tag) {
        this.xmlBuilder.append("<" + tag + ">");
    }

    private void close(String tag) {
        this.xmlBuilder.append("</" + tag + ">");
    }

    private void content(Object value) {
        this.xmlBuilder.append(value);
    }

    private String getSpaces(int indentLevels) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < indentLevels; ++i) {
            sb.append(INDENTATION);
        }
        return sb.toString();
    }

    private void newLine() {
        if (this.indentOutput) {
            this.xmlBuilder.append(NEW_LINE);
        }
    }

    private void indent(String spacing) {
        if (this.indentOutput) {
            this.xmlBuilder.append(spacing);
        }
    }
}

