/*
 * Decompiled with CFR 0.152.
 */
package me.weishu.epic.art.method;

import android.os.Build;
import com.taobao.android.dexposed.utility.Runtime;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import me.weishu.epic.art.EpicNative;

class Offset {
    private static final String TAG = "Offset";
    static Offset ART_QUICK_CODE_OFFSET;
    static Offset ART_ACCESS_FLAG_OFFSET;
    static Offset ART_JNI_ENTRY_OFFSET;
    private long offset;
    private BitWidth length;

    Offset() {
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public BitWidth getLength() {
        return this.length;
    }

    public void setLength(BitWidth length) {
        this.length = length;
    }

    public static long read(long base, Offset offset) {
        long address = base + offset.offset;
        byte[] bytes = EpicNative.get(address, offset.length.width);
        if (offset.length == BitWidth.DWORD) {
            return (long)ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).getInt() & 0xFFFFFFFFL;
        }
        return ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).getLong();
    }

    public static void write(long base, Offset offset, long value) {
        byte[] bytes;
        long address = base + offset.offset;
        if (offset.length == BitWidth.DWORD) {
            if (value > 0xFFFFFFFFL) {
                throw new IllegalStateException("overflow may occur");
            }
            bytes = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt((int)value).array();
        } else {
            bytes = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(value).array();
        }
        EpicNative.put(bytes, address);
    }

    private static void initFields() {
        block19: {
            int apiLevel;
            block18: {
                ART_QUICK_CODE_OFFSET = new Offset();
                ART_ACCESS_FLAG_OFFSET = new Offset();
                ART_JNI_ENTRY_OFFSET = new Offset();
                ART_ACCESS_FLAG_OFFSET.setLength(BitWidth.DWORD);
                apiLevel = Build.VERSION.SDK_INT;
                if (!Runtime.is64Bit()) break block18;
                ART_QUICK_CODE_OFFSET.setLength(BitWidth.QWORD);
                ART_JNI_ENTRY_OFFSET.setLength(BitWidth.QWORD);
                switch (apiLevel) {
                    case 28: 
                    case 29: 
                    case 30: {
                        ART_QUICK_CODE_OFFSET.setOffset(32L);
                        ART_JNI_ENTRY_OFFSET.setOffset(24L);
                        ART_ACCESS_FLAG_OFFSET.setOffset(4L);
                        break block19;
                    }
                    case 26: 
                    case 27: {
                        ART_QUICK_CODE_OFFSET.setOffset(40L);
                        ART_JNI_ENTRY_OFFSET.setOffset(32L);
                        ART_ACCESS_FLAG_OFFSET.setOffset(4L);
                        break block19;
                    }
                    case 24: 
                    case 25: {
                        ART_QUICK_CODE_OFFSET.setOffset(48L);
                        ART_JNI_ENTRY_OFFSET.setOffset(40L);
                        ART_ACCESS_FLAG_OFFSET.setOffset(4L);
                        break block19;
                    }
                    case 23: {
                        ART_QUICK_CODE_OFFSET.setOffset(48L);
                        ART_JNI_ENTRY_OFFSET.setOffset(40L);
                        ART_ACCESS_FLAG_OFFSET.setOffset(12L);
                        break block19;
                    }
                    case 22: {
                        ART_QUICK_CODE_OFFSET.setOffset(56L);
                        ART_JNI_ENTRY_OFFSET.setOffset(44L);
                        ART_ACCESS_FLAG_OFFSET.setOffset(20L);
                        break block19;
                    }
                    case 21: {
                        ART_QUICK_CODE_OFFSET.setOffset(40L);
                        ART_QUICK_CODE_OFFSET.setLength(BitWidth.QWORD);
                        ART_JNI_ENTRY_OFFSET.setOffset(32L);
                        ART_JNI_ENTRY_OFFSET.setLength(BitWidth.QWORD);
                        ART_ACCESS_FLAG_OFFSET.setOffset(56L);
                        break block19;
                    }
                    case 19: {
                        ART_QUICK_CODE_OFFSET.setOffset(32L);
                        ART_ACCESS_FLAG_OFFSET.setOffset(28L);
                        break block19;
                    }
                    default: {
                        throw new RuntimeException("API LEVEL: " + apiLevel + " is not supported now : (");
                    }
                }
            }
            ART_QUICK_CODE_OFFSET.setLength(BitWidth.DWORD);
            ART_JNI_ENTRY_OFFSET.setLength(BitWidth.DWORD);
            switch (apiLevel) {
                case 28: 
                case 29: {
                    ART_QUICK_CODE_OFFSET.setOffset(24L);
                    ART_JNI_ENTRY_OFFSET.setOffset(20L);
                    ART_ACCESS_FLAG_OFFSET.setOffset(4L);
                    break;
                }
                case 26: 
                case 27: {
                    ART_QUICK_CODE_OFFSET.setOffset(28L);
                    ART_JNI_ENTRY_OFFSET.setOffset(24L);
                    ART_ACCESS_FLAG_OFFSET.setOffset(4L);
                    break;
                }
                case 24: 
                case 25: {
                    ART_QUICK_CODE_OFFSET.setOffset(32L);
                    ART_JNI_ENTRY_OFFSET.setOffset(28L);
                    ART_ACCESS_FLAG_OFFSET.setOffset(4L);
                    break;
                }
                case 23: {
                    ART_QUICK_CODE_OFFSET.setOffset(36L);
                    ART_JNI_ENTRY_OFFSET.setOffset(32L);
                    ART_ACCESS_FLAG_OFFSET.setOffset(12L);
                    break;
                }
                case 22: {
                    ART_QUICK_CODE_OFFSET.setOffset(44L);
                    ART_JNI_ENTRY_OFFSET.setOffset(40L);
                    ART_ACCESS_FLAG_OFFSET.setOffset(20L);
                    break;
                }
                case 21: {
                    ART_QUICK_CODE_OFFSET.setOffset(40L);
                    ART_QUICK_CODE_OFFSET.setLength(BitWidth.QWORD);
                    ART_JNI_ENTRY_OFFSET.setOffset(32L);
                    ART_JNI_ENTRY_OFFSET.setLength(BitWidth.QWORD);
                    ART_ACCESS_FLAG_OFFSET.setOffset(56L);
                    break;
                }
                case 19: {
                    ART_QUICK_CODE_OFFSET.setOffset(32L);
                    ART_ACCESS_FLAG_OFFSET.setOffset(28L);
                    break;
                }
                default: {
                    throw new RuntimeException("API LEVEL: " + apiLevel + " is not supported now : (");
                }
            }
        }
    }

    static {
        Offset.initFields();
    }

    private static enum BitWidth {
        DWORD(4),
        QWORD(8);

        int width;

        private BitWidth(int width) {
            this.width = width;
        }
    }
}

