/*
 * Decompiled with CFR 0.152.
 */
package me.weishu.epic.art.entry;

import android.os.Build;
import android.util.Pair;
import com.taobao.android.dexposed.utility.Debug;
import com.taobao.android.dexposed.utility.Logger;
import de.robv.android.xposed.DexposedBridge;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import me.weishu.epic.art.Epic;
import me.weishu.epic.art.EpicNative;
import me.weishu.epic.art.method.ArtMethod;

public class Entry {
    private static final String TAG = "Entry";
    private static final Object[] EMPTY_OBJECT_ARRAY;
    private static Map<Class<?>, String> bridgeMethodMap;

    private static int onHookInt(Object artmethod, Object receiver, Object[] args) {
        return (Integer)DexposedBridge.handleHookedArtMethod(artmethod, receiver, args);
    }

    private static long onHookLong(Object artmethod, Object receiver, Object[] args) {
        return (Long)DexposedBridge.handleHookedArtMethod(artmethod, receiver, args);
    }

    private static double onHookDouble(Object artmethod, Object receiver, Object[] args) {
        return (Double)DexposedBridge.handleHookedArtMethod(artmethod, receiver, args);
    }

    private static char onHookChar(Object artmethod, Object receiver, Object[] args) {
        return ((Character)DexposedBridge.handleHookedArtMethod(artmethod, receiver, args)).charValue();
    }

    private static short onHookShort(Object artmethod, Object receiver, Object[] args) {
        return (Short)DexposedBridge.handleHookedArtMethod(artmethod, receiver, args);
    }

    private static float onHookFloat(Object artmethod, Object receiver, Object[] args) {
        return ((Float)DexposedBridge.handleHookedArtMethod(artmethod, receiver, args)).floatValue();
    }

    private static Object onHookObject(Object artmethod, Object receiver, Object[] args) {
        return DexposedBridge.handleHookedArtMethod(artmethod, receiver, args);
    }

    private static void onHookVoid(Object artmethod, Object receiver, Object[] args) {
        DexposedBridge.handleHookedArtMethod(artmethod, receiver, args);
    }

    private static boolean onHookBoolean(Object artmethod, Object receiver, Object[] args) {
        return (Boolean)DexposedBridge.handleHookedArtMethod(artmethod, receiver, args);
    }

    private static byte onHookByte(Object artmethod, Object receiver, Object[] args) {
        return (Byte)DexposedBridge.handleHookedArtMethod(artmethod, receiver, args);
    }

    private static void voidBridge(int r1, int self, int struct) {
        Entry.referenceBridge(r1, self, struct);
    }

    private static boolean booleanBridge(int r1, int self, int struct) {
        return (Boolean)Entry.referenceBridge(r1, self, struct);
    }

    private static byte byteBridge(int r1, int self, int struct) {
        return (Byte)Entry.referenceBridge(r1, self, struct);
    }

    private static short shortBridge(int r1, int self, int struct) {
        return (Short)Entry.referenceBridge(r1, self, struct);
    }

    private static char charBridge(int r1, int self, int struct) {
        return ((Character)Entry.referenceBridge(r1, self, struct)).charValue();
    }

    private static int intBridge(int r1, int self, int struct) {
        return (Integer)Entry.referenceBridge(r1, self, struct);
    }

    private static long longBridge(int r1, int self, int struct) {
        return (Long)Entry.referenceBridge(r1, self, struct);
    }

    private static float floatBridge(int r1, int self, int struct) {
        return ((Float)Entry.referenceBridge(r1, self, struct)).floatValue();
    }

    private static double doubleBridge(int r1, int self, int struct) {
        return (Double)Entry.referenceBridge(r1, self, struct);
    }

    private static Object referenceBridge(int r1, int self, int struct) {
        Logger.i(TAG, "enter bridge function.");
        Logger.i(TAG, "struct:" + Long.toHexString(struct));
        int sp = ByteBuffer.wrap(EpicNative.get(struct, 4)).order(ByteOrder.LITTLE_ENDIAN).getInt();
        byte[] rr1 = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(r1).array();
        byte[] r2 = EpicNative.get(struct + 4, 4);
        byte[] r3 = EpicNative.get(struct + 8, 4);
        Logger.d(TAG, "r1:" + Debug.hexdump(rr1, 0L));
        Logger.d(TAG, "r2:" + Debug.hexdump(r2, 0L));
        Logger.d(TAG, "r3:" + Debug.hexdump(r3, 0L));
        byte[] sourceAddr = EpicNative.get(struct + 12, 4);
        ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[8]);
        byteBuffer.put(sourceAddr);
        byteBuffer.put(new byte[]{0, 0, 0, 0});
        byteBuffer.flip();
        long sourceMethod = byteBuffer.order(ByteOrder.LITTLE_ENDIAN).getLong();
        Logger.i(TAG, "sourceMethod:" + Long.toHexString(sourceMethod));
        Epic.MethodInfo originMethodInfo = Epic.getMethodInfo(sourceMethod);
        Logger.i(TAG, "originMethodInfo :" + originMethodInfo);
        Pair<Object, Object[]> constructArguments = Entry.constructArguments(originMethodInfo, self, rr1, r2, r3, sp);
        Object receiver = constructArguments.first;
        Object[] arguments = (Object[])constructArguments.second;
        Logger.i(TAG, "arguments:" + Arrays.toString(arguments));
        Class<?> returnType = originMethodInfo.returnType;
        ArtMethod artMethod = originMethodInfo.method;
        Logger.i(TAG, "leave bridge function");
        if (returnType == Void.TYPE) {
            Entry.onHookVoid(artMethod, receiver, arguments);
            return 0;
        }
        if (returnType == Character.TYPE) {
            return Character.valueOf(Entry.onHookChar(artMethod, receiver, arguments));
        }
        if (returnType == Byte.TYPE) {
            return Entry.onHookByte(artMethod, receiver, arguments);
        }
        if (returnType == Short.TYPE) {
            return Entry.onHookShort(artMethod, receiver, arguments);
        }
        if (returnType == Integer.TYPE) {
            return Entry.onHookInt(artMethod, receiver, arguments);
        }
        if (returnType == Long.TYPE) {
            return Entry.onHookLong(artMethod, receiver, arguments);
        }
        if (returnType == Float.TYPE) {
            return Float.valueOf(Entry.onHookFloat(artMethod, receiver, arguments));
        }
        if (returnType == Double.TYPE) {
            return Entry.onHookDouble(artMethod, receiver, arguments);
        }
        if (returnType == Boolean.TYPE) {
            return Entry.onHookBoolean(artMethod, receiver, arguments);
        }
        return Entry.onHookObject(artMethod, receiver, arguments);
    }

    private static Pair<Object, Object[]> constructArguments(Epic.MethodInfo originMethodInfo, int self, byte[] r1, byte[] r2, byte[] r3, int sp) {
        byte[] argBytes;
        int argTotalLength;
        int[] argStartPos;
        Object[] arguments;
        Class<?>[] typeOfArgs;
        int numberOfArgs;
        boolean isStatic;
        block26: {
            block28: {
                block27: {
                    boolean align;
                    isStatic = originMethodInfo.isStatic;
                    if (isStatic) {
                        numberOfArgs = originMethodInfo.paramNumber;
                        typeOfArgs = originMethodInfo.paramTypes;
                    } else {
                        numberOfArgs = 1 + originMethodInfo.paramNumber;
                        typeOfArgs = new Class[numberOfArgs];
                        typeOfArgs[0] = Object.class;
                        System.arraycopy(originMethodInfo.paramTypes, 0, typeOfArgs, 1, originMethodInfo.paramTypes.length);
                    }
                    arguments = new Object[numberOfArgs];
                    int currentStackPosition = 4;
                    int argumentStackBegin = 16;
                    argStartPos = new int[numberOfArgs];
                    for (int i = 0; i < numberOfArgs; ++i) {
                        Class<?> typeOfArg = typeOfArgs[i];
                        int typeLength = Entry.getTypeLength(typeOfArg);
                        argStartPos[i] = currentStackPosition;
                        currentStackPosition += typeLength;
                    }
                    argTotalLength = currentStackPosition;
                    argBytes = new byte[argTotalLength];
                    if (argTotalLength <= 4) break block26;
                    boolean bl = align = Build.VERSION.SDK_INT >= 23 && numberOfArgs > 0 && Entry.getTypeLength(typeOfArgs[0]) == 8;
                    if (!align) break block27;
                    System.arraycopy(r2, 0, argBytes, 4, 4);
                    System.arraycopy(r3, 0, argBytes, 8, 4);
                    if (argTotalLength <= 12) break block26;
                    System.arraycopy(EpicNative.get(sp + 12, 4), 0, argBytes, 12, 4);
                    break block28;
                }
                System.arraycopy(r1, 0, argBytes, 4, 4);
                if (argTotalLength <= 8) break block26;
                System.arraycopy(r2, 0, argBytes, 8, 4);
                if (argTotalLength <= 12) break block26;
                System.arraycopy(r3, 0, argBytes, 12, 4);
            }
            if (argTotalLength > 16) {
                byte[] argInStack = EpicNative.get(sp + 16, argTotalLength - 16);
                System.arraycopy(argInStack, 0, argBytes, 16, argTotalLength - 16);
            }
        }
        if (Build.VERSION.SDK_INT == 23 && argTotalLength > 12) {
            if (argTotalLength <= 16) {
                if (Entry.getTypeLength(typeOfArgs[0]) == 8) {
                    System.arraycopy(EpicNative.get(sp + 44, 4), 0, argBytes, 12, 4);
                }
            } else {
                int arg2TypeLength;
                boolean isR3Grabbed = true;
                if (numberOfArgs >= 2) {
                    int arg1TypeLength = Entry.getTypeLength(typeOfArgs[0]);
                    arg2TypeLength = Entry.getTypeLength(typeOfArgs[1]);
                    if (arg1TypeLength == 4 && arg2TypeLength == 8) {
                        isR3Grabbed = false;
                    }
                    if (numberOfArgs == 2 && arg1TypeLength == 8 && arg2TypeLength == 8) {
                        System.arraycopy(EpicNative.get(sp + 44, 4), 0, argBytes, 12, 4);
                        isR3Grabbed = false;
                    }
                }
                if (numberOfArgs >= 3) {
                    int arg1TypeLength = Entry.getTypeLength(typeOfArgs[0]);
                    arg2TypeLength = Entry.getTypeLength(typeOfArgs[1]);
                    int arg3TypeLength = Entry.getTypeLength(typeOfArgs[2]);
                    if (arg1TypeLength == 4 && arg2TypeLength == 4 && arg3TypeLength == 4) {
                        isR3Grabbed = false;
                    }
                    if (numberOfArgs == 3 && arg1TypeLength == 8 && arg2TypeLength == 4 && arg3TypeLength == 8) {
                        System.arraycopy(EpicNative.get(sp + 52, 4), 0, argBytes, 12, 4);
                        isR3Grabbed = false;
                    }
                }
                if (isR3Grabbed) {
                    byte[] otherStoreInStack = Arrays.copyOfRange(argBytes, 16, argBytes.length);
                    int otherStoreInStackLength = otherStoreInStack.length;
                    int searchRegion = 0;
                    int i = 16 + otherStoreInStackLength;
                    while (true) {
                        byte[] bytes = EpicNative.get(sp + i, otherStoreInStackLength);
                        searchRegion += otherStoreInStackLength;
                        if (Arrays.equals(bytes, otherStoreInStack)) {
                            int originR3Index = sp + i - 4;
                            byte[] originR3 = EpicNative.get(originR3Index, 4);
                            Logger.d(TAG, "found other arguments in stack, index:" + i + ", origin r3:" + Arrays.toString(originR3));
                            System.arraycopy(originR3, 0, argBytes, 12, 4);
                            break;
                        }
                        if (searchRegion > 1024) {
                            throw new RuntimeException("can not found the modify r3 register!!!");
                        }
                        i += 4;
                    }
                }
            }
        }
        Logger.d(TAG, "argBytes: " + Debug.hexdump(argBytes, 0L));
        for (int i = 0; i < numberOfArgs; ++i) {
            Class<?> typeOfArg = typeOfArgs[i];
            int startPos = argStartPos[i];
            int typeLength = Entry.getTypeLength(typeOfArg);
            byte[] argWithBytes = Arrays.copyOfRange(argBytes, startPos, startPos + typeLength);
            arguments[i] = Entry.wrapArgument(typeOfArg, self, argWithBytes);
        }
        Object thiz = null;
        Object[] parameters = EMPTY_OBJECT_ARRAY;
        if (isStatic) {
            parameters = arguments;
        } else {
            thiz = arguments[0];
            int argumentLength = arguments.length;
            if (argumentLength > 1) {
                parameters = Arrays.copyOfRange(arguments, 1, argumentLength);
            }
        }
        return Pair.create((Object)thiz, (Object)parameters);
    }

    private static Object wrapArgument(Class<?> type, int self, byte[] value) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(value).order(ByteOrder.LITTLE_ENDIAN);
        Logger.d(TAG, "wrapArgument: type:" + type);
        if (type.isPrimitive()) {
            if (type == Integer.TYPE) {
                return byteBuffer.getInt();
            }
            if (type == Long.TYPE) {
                return byteBuffer.getLong();
            }
            if (type == Float.TYPE) {
                return Float.valueOf(byteBuffer.getFloat());
            }
            if (type == Short.TYPE) {
                return byteBuffer.getShort();
            }
            if (type == Byte.TYPE) {
                return byteBuffer.get();
            }
            if (type == Character.TYPE) {
                return Character.valueOf(byteBuffer.getChar());
            }
            if (type == Double.TYPE) {
                return byteBuffer.getDouble();
            }
            if (type == Boolean.TYPE) {
                return byteBuffer.getInt() != 0;
            }
            throw new RuntimeException("unknown type:" + type);
        }
        int address = byteBuffer.getInt();
        Object object = EpicNative.getObject(self, address);
        return object;
    }

    public static Method getBridgeMethod(Class<?> returnType) {
        try {
            String bridgeMethod = bridgeMethodMap.get(returnType.isPrimitive() ? returnType : Object.class);
            Logger.i(TAG, "bridge method:" + bridgeMethod + ", map:" + bridgeMethodMap);
            Method method = Entry.class.getDeclaredMethod(bridgeMethod, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            method.setAccessible(true);
            return method;
        }
        catch (Throwable e) {
            throw new RuntimeException("error", e);
        }
    }

    private static int getTypeLength(Class<?> clazz) {
        if (clazz == Long.TYPE || clazz == Double.TYPE) {
            return 8;
        }
        return 4;
    }

    static {
        Class[] primitiveTypes;
        EMPTY_OBJECT_ARRAY = new Object[0];
        bridgeMethodMap = new HashMap();
        for (Class primitiveType : primitiveTypes = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE}) {
            bridgeMethodMap.put(primitiveType, primitiveType.getName() + "Bridge");
        }
        bridgeMethodMap.put(Object.class, "referenceBridge");
        bridgeMethodMap.put(Void.TYPE, "voidBridge");
    }
}

