/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.android.dexposed.utility;

import android.content.Context;
import android.os.SystemClock;
import android.util.Log;
import java.lang.reflect.Method;

public class NougatPolicy {
    private static final String TAG = "NougatPolicy";

    public static boolean fullCompile(Context context) {
        try {
            long t1 = SystemClock.elapsedRealtime();
            Object pm = NougatPolicy.getPackageManagerBinderProxy();
            if (pm == null) {
                TraceLogger.e(TAG, "can not found package service");
                return false;
            }
            Method performDexOptMode = pm.getClass().getDeclaredMethod("performDexOptMode", String.class, Boolean.TYPE, String.class, Boolean.TYPE);
            boolean ret = (Boolean)performDexOptMode.invoke(pm, context.getPackageName(), false, "speed", true);
            long cost = SystemClock.elapsedRealtime() - t1;
            Log.i((String)TAG, (String)("full Compile cost: " + cost + " result:" + ret));
            return ret;
        }
        catch (Throwable e) {
            TraceLogger.e(TAG, "fullCompile failed:", e);
            return false;
        }
    }

    public static boolean clearCompileData(Context context) {
        boolean ret;
        try {
            Object pm = NougatPolicy.getPackageManagerBinderProxy();
            Method performDexOpt = pm.getClass().getDeclaredMethod("performDexOpt", String.class, Boolean.TYPE, Integer.TYPE, Boolean.TYPE);
            ret = (Boolean)performDexOpt.invoke(pm, context.getPackageName(), false, 2, true);
        }
        catch (Throwable e) {
            TraceLogger.e(TAG, "clear compile data failed", e);
            ret = false;
        }
        return ret;
    }

    private static Object getPackageManagerBinderProxy() throws Exception {
        Class<?> activityThread = Class.forName("android.app.ActivityThread");
        Method getPackageManager = activityThread.getDeclaredMethod("getPackageManager", new Class[0]);
        return getPackageManager.invoke(null, new Object[0]);
    }

    private static class TraceLogger {
        private TraceLogger() {
        }

        static void i(String tag, String msg) {
            Log.i((String)tag, (String)msg);
        }

        static void e(String tag, String msg) {
            Log.i((String)tag, (String)msg);
        }

        static void e(String tag, String msg, Throwable e) {
            Log.i((String)tag, (String)msg, (Throwable)e);
        }
    }
}

