/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.android.dexposed.utility;

import android.util.Log;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Method;
import me.weishu.epic.art.method.ArtMethod;

public final class Debug {
    private static final String TAG = "Dexposed";
    public static final boolean DEBUG = false;
    private static final String RELASE_WRAN_STRING = "none in release mode.";

    private Debug() {
    }

    public static String addrHex(long i) {
        return RELASE_WRAN_STRING;
    }

    public static String longHex(long i) {
        return String.format("0x%016X", i);
    }

    public static String intHex(int i) {
        return String.format("0x%08X", i);
    }

    public static String byteHex(byte b) {
        return String.format("%02X", b);
    }

    public static String dump(byte[] b, long start) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            if (i % 8 == 0) {
                sb.append(Debug.addrHex(start + (long)i)).append(":");
            }
            sb.append(Debug.byteHex(b[i])).append(" ");
            if (i % 8 != 7) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String hexdump(byte[] bytes, long start) {
        return RELASE_WRAN_STRING;
    }

    public static String methodDescription(Method method) {
        return method.getDeclaringClass().getName() + "->" + method.getName() + " @" + Debug.addrHex(ArtMethod.of(method).getEntryPointFromQuickCompiledCode()) + " +" + Debug.addrHex(ArtMethod.of(method).getAddress());
    }

    public static void dumpMaps() {
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new FileReader("/proc/self/maps"));
            while ((line = br.readLine()) != null) {
                Log.i((String)TAG, (String)line);
            }
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"dumpMaps error");
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

