/*
 * Decompiled with CFR 0.152.
 */
package br.tiagohm.markdownview.ext.button.internal;

import android.text.TextUtils;
import br.tiagohm.markdownview.ext.button.Button;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.html.CustomNodeRenderer;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.util.options.DataHolder;
import java.util.HashSet;
import java.util.Set;

public class ButtonNodeRenderer
implements NodeRenderer {
    public ButtonNodeRenderer(DataHolder options) {
    }

    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        HashSet set = new HashSet();
        set.add(new NodeRenderingHandler(Button.class, (CustomNodeRenderer)new CustomNodeRenderer<Button>(){

            public void render(Button node, NodeRendererContext context, HtmlWriter html) {
                ButtonNodeRenderer.this.render(node, context, html);
            }
        }));
        return set;
    }

    private void render(Button node, NodeRendererContext context, HtmlWriter html) {
        String id = node.getUrl().toString();
        if (!TextUtils.isEmpty((CharSequence)id)) {
            html.attr((CharSequence)"id", (CharSequence)id);
            html.attr((CharSequence)"onclick", (CharSequence)String.format("javascript:android.onButtonTap('%s');", id));
            html.srcPos(node.getChars()).withAttr().tag((CharSequence)"button");
            context.renderChildren((Node)node);
            html.tag((CharSequence)"/button");
        } else {
            context.renderChildren((Node)node);
        }
    }

    public static class Factory
    implements NodeRendererFactory {
        public NodeRenderer create(DataHolder options) {
            return new ButtonNodeRenderer(options);
        }
    }
}

