/*
 * Decompiled with CFR 0.152.
 */
package br.tiagohm.markdownview.css;

import br.tiagohm.markdownview.css.StyleSheet;
import java.io.File;
import java.net.URL;

public class ExternalStyleSheet
implements StyleSheet {
    private String mUrl;
    private String mMediaQuery;

    public ExternalStyleSheet(String url) {
        this.mUrl = url;
    }

    public ExternalStyleSheet(String url, String mediaQuery) {
        this(url);
        this.mMediaQuery = mediaQuery;
    }

    public static ExternalStyleSheet fromUrl(URL url, String mediaQuery) {
        return new ExternalStyleSheet(url.toString(), mediaQuery);
    }

    public static ExternalStyleSheet fromFile(File file, String mediaQuery) {
        return new ExternalStyleSheet(file.getAbsolutePath(), mediaQuery);
    }

    public static StyleSheet fromAsset(String path, String mediaQuery) {
        return new ExternalStyleSheet("file:///android_asset/" + path, mediaQuery);
    }

    public String getUrl() {
        return this.mUrl;
    }

    public String getMediaQuery() {
        return this.mMediaQuery;
    }

    public String toString() {
        return this.getUrl();
    }

    @Override
    public String toHTML() {
        return String.format("<link rel=\"stylesheet\" type=\"text/css\" media=\"%s\" href=\"%s\" />", this.getMediaQuery() == null ? "" : this.getMediaQuery(), this.getUrl());
    }
}

