/*
 * Decompiled with CFR 0.152.
 */
package br.tiagohm.markdownview;

import android.content.res.AssetManager;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class Utils {
    private Utils() {
    }

    public static String getStringFromInputStream(InputStream is) throws IOException {
        int length;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = is.read(buffer)) != -1) {
            baos.write(buffer, 0, length);
        }
        return baos.toString("UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStringFromAssetFile(AssetManager asset, String filename) {
        InputStream is = null;
        try {
            is = asset.open(filename);
            String string = Utils.getStringFromInputStream(is);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = "";
            return string;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStringFromFile(File file) {
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            String string = Utils.getStringFromInputStream(is);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = "";
            return string;
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

