/*
 * Decompiled with CFR 0.152.
 */
package br.tiagohm.markdownview;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.AsyncTask;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.widget.FrameLayout;
import br.tiagohm.markdownview.R;
import br.tiagohm.markdownview.Utils;
import br.tiagohm.markdownview.ext.emoji.EmojiExtension;
import br.tiagohm.markdownview.ext.kbd.KeystrokeExtension;
import br.tiagohm.markdownview.ext.mark.MarkExtension;
import br.tiagohm.markdownview.ext.mathjax.MathJaxExtension;
import com.orhanobut.logger.Logger;
import com.vladsch.flexmark.Extension;
import com.vladsch.flexmark.ast.Image;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ast.util.TextCollectingVisitor;
import com.vladsch.flexmark.ext.abbreviation.AbbreviationExtension;
import com.vladsch.flexmark.ext.autolink.AutolinkExtension;
import com.vladsch.flexmark.ext.footnotes.FootnoteExtension;
import com.vladsch.flexmark.ext.gfm.strikethrough.StrikethroughSubscriptExtension;
import com.vladsch.flexmark.ext.gfm.tasklist.TaskListExtension;
import com.vladsch.flexmark.ext.tables.TablesExtension;
import com.vladsch.flexmark.html.CustomNodeRenderer;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.LinkType;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.html.renderer.ResolvedLink;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.superscript.SuperscriptExtension;
import com.vladsch.flexmark.util.html.Escaping;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.options.MutableDataHolder;
import com.vladsch.flexmark.util.options.MutableDataSet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MarkdownView
extends FrameLayout {
    private static final List<Extension> EXTENSIONS = Arrays.asList(TablesExtension.create(), TaskListExtension.create(), AbbreviationExtension.create(), AutolinkExtension.create(), MarkExtension.create(), StrikethroughSubscriptExtension.create(), SuperscriptExtension.create(), KeystrokeExtension.create(), MathJaxExtension.create(), FootnoteExtension.create(), EmojiExtension.create());
    private final DataHolder OPTIONS = new MutableDataSet().set(FootnoteExtension.FOOTNOTE_REF_PREFIX, (Object)"[").set(FootnoteExtension.FOOTNOTE_REF_SUFFIX, (Object)"]").set(HtmlRenderer.FENCED_CODE_LANGUAGE_CLASS_PREFIX, (Object)"").set(HtmlRenderer.FENCED_CODE_NO_LANGUAGE_CLASS, (Object)"nohighlight");
    private WebView mWebView;
    private boolean mEscapeHtml = true;

    public MarkdownView(Context context) {
        this(context, null);
    }

    public MarkdownView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MarkdownView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mWebView = new WebView(context, null, 0);
        this.mWebView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        try {
            this.mWebView.getSettings().setJavaScriptEnabled(true);
            this.mWebView.getSettings().setLoadsImagesAutomatically(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            TypedArray attr = this.getContext().obtainStyledAttributes(attrs, R.styleable.MarkdownView);
            this.mEscapeHtml = attr.getBoolean(R.styleable.MarkdownView_escapeHtml, true);
            attr.recycle();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.addView((View)this.mWebView);
    }

    public MarkdownView setEscapeHtml(boolean flag) {
        this.mEscapeHtml = flag;
        return this;
    }

    public MarkdownView setEmojiRootPath(String path) {
        ((MutableDataHolder)this.OPTIONS).set(EmojiExtension.ROOT_IMAGE_PATH, (Object)path);
        return this;
    }

    public MarkdownView setEmojiImageExtension(String ext) {
        ((MutableDataHolder)this.OPTIONS).set(EmojiExtension.IMAGE_EXT, (Object)ext);
        return this;
    }

    private String parseBuildAndRender(String text) {
        Parser parser = Parser.builder((DataHolder)this.OPTIONS).extensions(EXTENSIONS).build();
        HtmlRenderer renderer = HtmlRenderer.builder((DataHolder)this.OPTIONS).escapeHtml(this.mEscapeHtml).nodeRendererFactory((NodeRendererFactory)new NodeRendererFactoryImpl()).extensions(EXTENSIONS).build();
        return renderer.render(parser.parse(text));
    }

    public void loadMarkdown(String text, String cssPath) {
        String html = this.parseBuildAndRender(text);
        StringBuilder sb = new StringBuilder();
        html = sb.append("<html>\n").append("<head>\n").append("<link rel=\"stylesheet\" href=\"file:///android_asset/css/default.css\">").append("<link rel=\"stylesheet\" href=\"").append(cssPath == null ? "" : cssPath).append("\" />\n").append("</head>\n").append("<body class=\"markdown-body\">\n").append(html).append("<span id='tooltip'></span>\n").append("<script type='text/javascript' src='file:///android_asset/js/jquery-3.1.1.min.js'></script>\n").append("<script type='text/javascript' src='file:///android_asset/js/markdownview.js'></script>\n").append("<script type='text/javascript' src='file:///android_asset/js/highlight.js'></script>\n").append("<script>hljs.initHighlightingOnLoad();</script>").append("<script type=\"text/x-mathjax-config\"> MathJax.Hub.Config({showProcessingMessages: false, messageStyle: 'none', showMathMenu: false, tex2jax: {inlineMath: [['$','$']]}});</script>\n").append("<script type=\"text/javascript\" src=\"https://cdn.mathjax.org/mathjax/latest/MathJax.js?config=TeX-AMS_CHTML\"></script>\n").append("</body>\n").append("</html>").toString();
        Logger.d((Object)html);
        this.mWebView.loadDataWithBaseURL("", html, "text/html", "UTF-8", "");
    }

    public void loadMarkdownFromAsset(String path, String cssPath) {
        this.loadMarkdown(Utils.getStringFromAssetFile(this.getContext().getAssets(), path), cssPath);
    }

    public void loadMarkdownFromFile(File file, String cssPath) {
        this.loadMarkdown(Utils.getStringFromFile(file), cssPath);
    }

    public void loadMarkdownFromUrl(String url, String cssPath) {
        new LoadMarkdownUrlTask().execute(new String[]{url, cssPath});
    }

    private class LoadMarkdownUrlTask
    extends AsyncTask<String, Void, String> {
        private String cssPath;

        private LoadMarkdownUrlTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected String doInBackground(String ... params) {
            String url = params[0];
            this.cssPath = params[1];
            InputStream is = null;
            try {
                URLConnection connection = new URL(url).openConnection();
                connection.setReadTimeout(5000);
                connection.setConnectTimeout(5000);
                connection.setRequestProperty("Accept-Charset", "UTF-8");
                is = connection.getInputStream();
                String string = Utils.getStringFromInputStream(is);
                return string;
            }
            catch (Exception e) {
                e.printStackTrace();
                String string = "";
                return string;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        protected void onPostExecute(String s) {
            MarkdownView.this.loadMarkdown(s, this.cssPath);
        }
    }

    public static class NodeRendererFactoryImpl
    implements NodeRendererFactory {
        public NodeRenderer create(DataHolder options) {
            return new NodeRenderer(){

                public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
                    HashSet set = new HashSet();
                    set.add(new NodeRenderingHandler(Image.class, (CustomNodeRenderer)new CustomNodeRenderer<Image>(){

                        public void render(Image node, NodeRendererContext context, HtmlWriter html) {
                            if (!context.isDoNotRenderLinks()) {
                                int index;
                                String altText = new TextCollectingVisitor().collectAndGetText((Node)node);
                                ResolvedLink resolvedLink = context.resolveLink(LinkType.IMAGE, (CharSequence)node.getUrl().unescape(), null);
                                String url = resolvedLink.getUrl();
                                if (!node.getUrlContent().isEmpty()) {
                                    String content = Escaping.percentEncodeUrl((CharSequence)node.getUrlContent()).replace("+", "%2B").replace("%3D", "=").replace("%26", "&amp;");
                                    url = url + content;
                                }
                                if ((index = url.indexOf(64)) >= 0) {
                                    String[] dimensions = url.substring(index + 1, url.length()).split("\\|");
                                    url = url.substring(0, index);
                                    if (dimensions.length == 2) {
                                        String width = TextUtils.isEmpty((CharSequence)dimensions[0]) ? "auto" : dimensions[0];
                                        String height = TextUtils.isEmpty((CharSequence)dimensions[1]) ? "auto" : dimensions[1];
                                        html.attr((CharSequence)"style", (CharSequence)("width: " + width + "; height: " + height));
                                    }
                                }
                                html.attr((CharSequence)"src", (CharSequence)url);
                                html.attr((CharSequence)"alt", (CharSequence)altText);
                                if (node.getTitle().isNotNull()) {
                                    html.attr((CharSequence)"title", (CharSequence)node.getTitle().unescape());
                                }
                                html.srcPos(node.getChars()).withAttr(resolvedLink).tagVoid((CharSequence)"img");
                            }
                        }
                    }));
                    return set;
                }
            };
        }
    }

    public static interface Styles {
        public static final String GITHUB = "file:///android_asset/css/github.css";
        public static final String ELECTRON = "file:///android_asset/css/electron.css";
    }
}

