/*
 * Decompiled with CFR 0.152.
 */
package com.github.thomasdarimont.keycloak.embedded.support;

import com.github.thomasdarimont.keycloak.embedded.KeycloakProperties;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.keycloak.Config;

public class SpringBootConfigProvider
implements Config.ConfigProvider {
    private static SpringBootConfigProvider INSTANCE;
    private final KeycloakProperties keycloakProperties;

    public SpringBootConfigProvider(KeycloakProperties keycloakProperties) {
        this.keycloakProperties = keycloakProperties;
        INSTANCE = this;
    }

    public static SpringBootConfigProvider getInstance() {
        return INSTANCE;
    }

    public String getProvider(String spi) {
        return this.scope(spi).get("provider");
    }

    public Config.Scope scope(String ... scopes) {
        if (scopes == null || scopes.length == 0) {
            return new MapScope(this.keycloakProperties);
        }
        String scope = scopes[0];
        Object currentScopeValue = this.keycloakProperties.get(scope);
        if (!(currentScopeValue instanceof Map)) {
            return new MapScope(Collections.emptyMap());
        }
        Map scopeMap = (Map)currentScopeValue;
        for (int i = 1; i < scopes.length; ++i) {
            currentScopeValue = scopeMap.get(scopes[i]);
            if (!(currentScopeValue instanceof Map)) continue;
            scopeMap = (Map)currentScopeValue;
        }
        return new MapScope(scopeMap);
    }

    class MapScope
    implements Config.Scope {
        private final Map<String, Object> map;

        private Object getObject(String key, Object defaultValue) {
            Object obj = this.map.get(key);
            if (obj == null) {
                return defaultValue;
            }
            return obj;
        }

        public String get(String key) {
            return this.get(key, null);
        }

        public String get(String key, String defaultValue) {
            Object obj = this.getObject(key, defaultValue);
            if (obj == null) {
                return defaultValue;
            }
            return String.valueOf(obj);
        }

        public String[] getArray(String key) {
            Object obj = this.getObject(key, null);
            if (obj == null) {
                return null;
            }
            if (obj instanceof LinkedHashMap) {
                LinkedHashMap lm = (LinkedHashMap)obj;
                String[] strings = new String[lm.size()];
                int i = 0;
                for (Object entryValue : lm.values()) {
                    strings[i++] = String.valueOf(entryValue);
                }
                return strings;
            }
            return (String[])obj;
        }

        public Integer getInt(String key) {
            return this.getInt(key, null);
        }

        public Integer getInt(String key, Integer defaultValue) {
            Object obj = this.getObject(key, null);
            if (obj == null) {
                return defaultValue;
            }
            return Integer.valueOf(String.valueOf(obj));
        }

        public Long getLong(String key) {
            return this.getLong(key, null);
        }

        public Long getLong(String key, Long defaultValue) {
            Object obj = this.getObject(key, null);
            if (obj == null) {
                return defaultValue;
            }
            return Long.valueOf(String.valueOf(obj));
        }

        public Boolean getBoolean(String key) {
            return this.getBoolean(key, null);
        }

        public Boolean getBoolean(String key, Boolean defaultValue) {
            Object obj = this.getObject(key, null);
            if (obj == null) {
                return defaultValue;
            }
            return Boolean.valueOf(String.valueOf(obj));
        }

        public Config.Scope scope(String ... path) {
            return SpringBootConfigProvider.this.scope(path);
        }

        public Set<String> getPropertyNames() {
            return this.map.keySet();
        }

        public MapScope(Map<String, Object> map) {
            this.map = map;
        }
    }
}

