/*
 * Decompiled with CFR 0.152.
 */
package com.github.thomasdarimont.keycloak.embedded;

import org.jboss.logging.Logger;
import org.keycloak.common.Profile;
import org.keycloak.common.Version;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;

public class EmbeddedKeycloakServer {
    private static final Logger log = Logger.getLogger(EmbeddedKeycloakServer.class);
    private final ServerProperties serverProperties;

    @Bean
    public ApplicationListener<ApplicationReadyEvent> onApplicationReadyEventListener() {
        return evt -> {
            log.infof("Using Keycloak Version: %s", (Object)Version.VERSION_KEYCLOAK);
            log.infof("Enabled Keycloak Features (Deprecated): %s", (Object)Profile.getDeprecatedFeatures());
            log.infof("Enabled Keycloak Features (Preview): %s", (Object)Profile.getPreviewFeatures());
            log.infof("Enabled Keycloak Features (Experimental): %s", (Object)Profile.getExperimentalFeatures());
            log.infof("Enabled Keycloak Features (Disabled): %s", (Object)Profile.getDisabledFeatures());
            Integer port = this.serverProperties.getPort();
            log.infof("Embedded Keycloak started: Browse to <http://localhost:%d%s> to use keycloak%n", (Object)port, (Object)this.serverProperties.getServlet().getContextPath());
        };
    }

    public EmbeddedKeycloakServer(ServerProperties serverProperties) {
        this.serverProperties = serverProperties;
    }
}

