/*
 * Decompiled with CFR 0.152.
 */
package com.github.thomasdarimont.keycloak.embedded.support;

import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.boot.env.YamlPropertySourceLoader;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.lang.NonNull;

public class PopulateKeycloakPropertiesApplicationListener
implements ApplicationListener<ApplicationEvent> {
    private static final Logger log = LoggerFactory.getLogger(PopulateKeycloakPropertiesApplicationListener.class);

    public void onApplicationEvent(@NonNull ApplicationEvent event) {
        if (!(event instanceof ApplicationEnvironmentPreparedEvent)) {
            return;
        }
        ApplicationEnvironmentPreparedEvent envEvent = (ApplicationEnvironmentPreparedEvent)event;
        ConfigurableEnvironment env = envEvent.getEnvironment();
        try {
            ClassPathResource resource = new ClassPathResource("keycloak-defaults.yml");
            if (!resource.exists()) {
                return;
            }
            log.info("Loading default keycloak properties configuration from: {}", (Object)resource.getURI());
            YamlPropertySourceLoader sourceLoader = new YamlPropertySourceLoader();
            List yamlTestProperties = sourceLoader.load("keycloak-defaults.yml", (Resource)resource);
            if (!yamlTestProperties.isEmpty()) {
                env.getPropertySources().addLast((PropertySource)yamlTestProperties.get(0));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

