/*
 * Decompiled with CFR 0.152.
 */
package com.github.thomasdarimont.keycloak.embedded;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

@ConfigurationProperties(prefix="keycloak.custom")
public class KeycloakCustomProperties {
    Server server = new Server();
    AdminUser adminUser = new AdminUser();
    Migration migration = new Migration();
    Infinispan infinispan = new Infinispan();

    public Server getServer() {
        return this.server;
    }

    public AdminUser getAdminUser() {
        return this.adminUser;
    }

    public Migration getMigration() {
        return this.migration;
    }

    public Infinispan getInfinispan() {
        return this.infinispan;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public void setAdminUser(AdminUser adminUser) {
        this.adminUser = adminUser;
    }

    public void setMigration(Migration migration) {
        this.migration = migration;
    }

    public void setInfinispan(Infinispan infinispan) {
        this.infinispan = infinispan;
    }

    public static class AdminUser {
        boolean createAdminUserEnabled = true;
        String username = "admin";
        String password;

        public boolean isCreateAdminUserEnabled() {
            return this.createAdminUserEnabled;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setCreateAdminUserEnabled(boolean createAdminUserEnabled) {
            this.createAdminUserEnabled = createAdminUserEnabled;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public void setPassword(String password) {
            this.password = password;
        }
    }

    public static class Infinispan {
        Resource configLocation = new ClassPathResource("infinispan.xml");

        public Resource getConfigLocation() {
            return this.configLocation;
        }

        public void setConfigLocation(Resource configLocation) {
            this.configLocation = configLocation;
        }
    }

    public static class Migration {
        Resource importLocation = new FileSystemResource("keycloak-realm-config.json");
        String importProvider = "singleFile";

        public Resource getImportLocation() {
            return this.importLocation;
        }

        public String getImportProvider() {
            return this.importProvider;
        }

        public void setImportLocation(Resource importLocation) {
            this.importLocation = importLocation;
        }

        public void setImportProvider(String importProvider) {
            this.importProvider = importProvider;
        }
    }

    public static class Server {
        String keycloakPath = "/auth";

        public String getKeycloakPath() {
            return this.keycloakPath;
        }

        public void setKeycloakPath(String keycloakPath) {
            this.keycloakPath = keycloakPath;
        }
    }
}

