/*
 * Decompiled with CFR 0.152.
 */
package com.pacific.adapter;

import android.content.Context;
import android.support.v4.view.PagerAdapter;
import android.view.View;
import android.view.ViewGroup;
import com.pacific.adapter.DataIO;
import com.pacific.adapter.PagerAdapterHelper;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

abstract class BaseViewPagerAdapter<T, H extends PagerAdapterHelper>
extends PagerAdapter
implements DataIO<T> {
    protected final Context context;
    protected final int layoutResId;
    protected final ArrayList<T> data;
    protected Queue<View> cacheViews;
    protected int currentPosition = -1;
    protected View currentTarget;

    public BaseViewPagerAdapter(Context context) {
        this(context, null, 0);
    }

    public BaseViewPagerAdapter(Context context, int layoutResId) {
        this(context, null, layoutResId);
    }

    public BaseViewPagerAdapter(Context context, List<T> data, int layoutResId) {
        this.data = data == null ? new ArrayList() : new ArrayList<T>(data);
        this.context = context;
        this.layoutResId = layoutResId;
        this.cacheViews = new LinkedList<View>();
    }

    @Override
    public void add(T elem) {
        this.data.add(elem);
        this.notifyDataSetChanged();
    }

    @Override
    public void addAt(int location, T elem) {
        this.data.add(location, elem);
        this.notifyDataSetChanged();
    }

    @Override
    public void addAll(List<T> elements) {
        this.data.addAll(elements);
        this.notifyDataSetChanged();
    }

    @Override
    public void addAllAt(int location, List<T> elements) {
        this.data.addAll(location, elements);
        this.notifyDataSetChanged();
    }

    @Override
    public void remove(T elem) {
        this.data.remove(elem);
        this.notifyDataSetChanged();
    }

    @Override
    public void removeAt(int index) {
        this.data.remove(index);
        this.notifyDataSetChanged();
    }

    @Override
    public void removeAll(List<T> elements) {
        this.data.removeAll(elements);
        this.notifyDataSetChanged();
    }

    @Override
    public void clear() {
        if (this.data != null && this.data.size() > 0) {
            this.data.clear();
            this.notifyDataSetChanged();
        }
    }

    @Override
    public void replace(T oldElem, T newElem) {
        this.replaceAt(this.data.indexOf(oldElem), newElem);
    }

    @Override
    public void replaceAt(int index, T elem) {
        this.data.set(index, elem);
        this.notifyDataSetChanged();
    }

    @Override
    public void replaceAll(List<T> elements) {
        if (this.data.size() > 0) {
            this.data.clear();
        }
        this.data.addAll(elements);
        this.notifyDataSetChanged();
    }

    @Override
    public T get(int position) {
        if (position >= this.data.size()) {
            return null;
        }
        return this.data.get(position);
    }

    @Override
    public ArrayList<T> getAll() {
        return this.data;
    }

    @Override
    public int getSize() {
        return this.data.size();
    }

    @Override
    public boolean contains(T elem) {
        return this.data.contains(elem);
    }

    @Override
    public void onEmptyData() {
    }

    @Override
    public void onHasData() {
    }

    public void notifyDataSetChanged() {
        super.notifyDataSetChanged();
        if (this.getSize() == 0) {
            this.onEmptyData();
        } else {
            this.onHasData();
        }
    }

    public int getCount() {
        return this.getSize();
    }

    public boolean isViewFromObject(View view, Object object) {
        return view == object;
    }

    public Object instantiateItem(ViewGroup container, int position) {
        H helper = this.getAdapterHelper(position, this.cacheViews.poll(), container);
        T item = this.get(position);
        this.convert(helper, item);
        return ((PagerAdapterHelper)helper).getItemView();
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        if (object instanceof View) {
            container.removeView((View)object);
            this.cacheViews.add((View)object);
        }
    }

    public void setPrimaryItem(ViewGroup container, int position, Object object) {
        this.currentPosition = position;
        if (object instanceof View) {
            this.currentTarget = (View)object;
        }
    }

    protected View createView(ViewGroup container, int position) {
        throw new RuntimeException("Required method createView was not overridden");
    }

    public int getCurrentPosition() {
        return this.currentPosition;
    }

    public View getCurrentTarget() {
        return this.currentTarget;
    }

    protected abstract void convert(H var1, T var2);

    protected abstract H getAdapterHelper(int var1, View var2, ViewGroup var3);
}

