/*
 * Decompiled with CFR 0.152.
 */
package com.pacific.adapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import com.pacific.adapter.DataIO;
import com.pacific.adapter.RecyclerAdapterHelper;
import java.util.ArrayList;
import java.util.List;

abstract class BaseRecyclerAdapter<T, H extends RecyclerAdapterHelper>
extends RecyclerView.Adapter<RecyclerView.ViewHolder>
implements DataIO<T> {
    protected final Context context;
    protected final LayoutInflater layoutInflater;
    protected final int[] layoutResIds;
    protected final ArrayList<T> data;

    public BaseRecyclerAdapter(Context context, int ... layoutResIds) {
        this(context, null, layoutResIds);
    }

    public BaseRecyclerAdapter(Context context, List<T> data, int ... layoutResIds) {
        this.context = context;
        this.layoutResIds = layoutResIds;
        this.layoutInflater = LayoutInflater.from((Context)context);
        this.data = data == null ? new ArrayList() : new ArrayList<T>(data);
    }

    public int getItemViewType(int position) {
        if (this.getViewTypeCount() == 1) {
            return super.getItemViewType(position);
        }
        throw new RuntimeException("Required method getItemViewType was not overridden");
    }

    public int getViewTypeCount() {
        return this.layoutResIds.length;
    }

    public int getLayoutResId(int viewType) {
        throw new RuntimeException("Required method getLayoutResId was not overridden");
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        int layoutResId = this.getViewTypeCount() > 1 ? this.getLayoutResId(viewType) : this.layoutResIds[0];
        return new RecyclerView.ViewHolder(this.layoutInflater.inflate(layoutResId, parent, false)){};
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        H helper = this.getAdapterHelper(holder);
        T item = this.get(position);
        this.convert(helper, item);
    }

    public int getItemCount() {
        return this.getSize();
    }

    @Override
    public void add(T elem) {
        this.data.add(elem);
        this.notifyDataSetChanged();
        this.onDataSetChanged();
    }

    @Override
    public void addAt(int location, T elem) {
        this.data.add(location, elem);
        this.notifyDataSetChanged();
        this.onDataSetChanged();
    }

    @Override
    public void addAll(List<T> elements) {
        this.data.addAll(elements);
        this.notifyDataSetChanged();
        this.onDataSetChanged();
    }

    @Override
    public void addAllAt(int location, List<T> elements) {
        this.data.addAll(location, elements);
        this.notifyDataSetChanged();
        this.onDataSetChanged();
    }

    @Override
    public void remove(T elem) {
        this.data.remove(elem);
        this.notifyDataSetChanged();
        this.onDataSetChanged();
    }

    @Override
    public void removeAt(int index) {
        this.data.remove(index);
        this.notifyDataSetChanged();
        this.onDataSetChanged();
    }

    @Override
    public void removeAll(List<T> elements) {
        this.data.removeAll(elements);
        this.notifyDataSetChanged();
        this.onDataSetChanged();
    }

    @Override
    public void clear() {
        if (this.data != null && this.data.size() > 0) {
            this.data.clear();
            this.notifyDataSetChanged();
            this.onDataSetChanged();
        }
    }

    @Override
    public void replace(T oldElem, T newElem) {
        this.replaceAt(this.data.indexOf(oldElem), newElem);
    }

    @Override
    public void replaceAt(int index, T elem) {
        this.data.set(index, elem);
        this.notifyDataSetChanged();
    }

    @Override
    public void replaceAll(List<T> elements) {
        if (this.data.size() > 0) {
            this.data.clear();
        }
        this.data.addAll(elements);
        this.notifyDataSetChanged();
        this.onDataSetChanged();
    }

    @Override
    public T get(int position) {
        if (position >= this.data.size()) {
            return null;
        }
        return this.data.get(position);
    }

    @Override
    public ArrayList<T> getAll() {
        return this.data;
    }

    @Override
    public int getSize() {
        return this.data.size();
    }

    @Override
    public boolean contains(T elem) {
        return this.data.contains(elem);
    }

    @Override
    public void onEmptyData() {
    }

    @Override
    public void onHasData() {
    }

    public void onDataSetChanged() {
        if (this.getSize() == 0) {
            this.onEmptyData();
        } else {
            this.onHasData();
        }
    }

    protected abstract void convert(H var1, T var2);

    protected abstract H getAdapterHelper(RecyclerView.ViewHolder var1);
}

