/*
 * Decompiled with CFR 0.152.
 */
package com.alamkanak.weekview.jodatime;

import com.alamkanak.weekview.WeekView;
import com.alamkanak.weekview.jodatime.DateExtensionsKt;
import java.util.Calendar;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.LocalDate;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR(\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\r\"\u0004\b\u0013\u0010\u0014R(\u0010\u0015\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\r\"\u0004\b\u0017\u0010\u0014R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/alamkanak/weekview/jodatime/WeekViewAdapter;", "T", "", "weekView", "Lcom/alamkanak/weekview/WeekView;", "(Lcom/alamkanak/weekview/WeekView;)V", "firstDayOfWeek", "", "getFirstDayOfWeek", "()I", "firstVisibleDate", "Lorg/joda/time/LocalDate;", "getFirstVisibleDate", "()Lorg/joda/time/LocalDate;", "lastVisibleDate", "getLastVisibleDate", "value", "maxDate", "getMaxDate", "setMaxDate", "(Lorg/joda/time/LocalDate;)V", "minDate", "getMinDate", "setMinDate", "jodatime_release"})
public final class WeekViewAdapter<T> {
    private final WeekView<T> weekView;

    public final int getFirstDayOfWeek() {
        int n;
        int day = this.weekView.getFirstDayOfWeek();
        if (day == 2) {
            n = 1;
        } else if (day == 3) {
            n = 2;
        } else if (day == 4) {
            n = 3;
        } else if (day == 5) {
            n = 4;
        } else if (day == 6) {
            n = 5;
        } else if (day == 7) {
            n = 6;
        } else if (day == 1) {
            n = 7;
        } else {
            throw (Throwable)new IllegalArgumentException("Unknown day of week: " + day);
        }
        return n;
    }

    @Nullable
    public final LocalDate getMinDate() {
        Calendar calendar = this.weekView.getMinDate();
        return calendar != null ? DateExtensionsKt.toLocalDate(calendar) : null;
    }

    public final void setMinDate(@Nullable LocalDate value) {
        LocalDate localDate = value;
        this.weekView.setMinDate(localDate != null ? DateExtensionsKt.toCalendar(localDate) : null);
    }

    @Nullable
    public final LocalDate getMaxDate() {
        Calendar calendar = this.weekView.getMaxDate();
        return calendar != null ? DateExtensionsKt.toLocalDate(calendar) : null;
    }

    public final void setMaxDate(@Nullable LocalDate value) {
        LocalDate localDate = value;
        this.weekView.setMaxDate(localDate != null ? DateExtensionsKt.toCalendar(localDate) : null);
    }

    @Nullable
    public final LocalDate getFirstVisibleDate() {
        Calendar calendar = this.weekView.getFirstVisibleDate();
        return calendar != null ? DateExtensionsKt.toLocalDate(calendar) : null;
    }

    @Nullable
    public final LocalDate getLastVisibleDate() {
        Calendar calendar = this.weekView.getLastVisibleDate();
        return calendar != null ? DateExtensionsKt.toLocalDate(calendar) : null;
    }

    public WeekViewAdapter(@NotNull WeekView<T> weekView) {
        Intrinsics.checkParameterIsNotNull(weekView, (String)"weekView");
        this.weekView = weekView;
    }
}

