/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.library;

import com.github.sanctum.labyrinth.formatting.string.ColoredString;
import java.util.logging.Logger;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class Message {
    private final Logger logger = Logger.getLogger("Minecraft");
    private final String prefix;
    private Player p;

    public Message(String prefix) {
        this.prefix = prefix;
    }

    public void assignPlayer(Player player) {
        this.p = player;
    }

    public Message(Player p) {
        this.p = p;
        this.prefix = "";
    }

    public Message(Player p, String prefix) {
        this.p = p;
        this.prefix = prefix;
    }

    public void send(String text) {
        String result = this.prefix == null || this.prefix.isEmpty() ? (Bukkit.getVersion().contains("1.16") ? new ColoredString(text, ColoredString.ColorType.HEX).toString() : new ColoredString(text, ColoredString.ColorType.MC).toString()) : (Bukkit.getVersion().contains("1.16") ? new ColoredString(this.prefix + " " + text, ColoredString.ColorType.HEX).toString() : new ColoredString(this.prefix + " " + text, ColoredString.ColorType.MC).toString());
        this.p.sendMessage(result);
    }

    public void build(TextComponent component) {
        this.p.spigot().sendMessage((BaseComponent)component);
    }

    public void build(BaseComponent ... components) {
        this.p.spigot().sendMessage(components);
    }

    public void info(String text) {
        this.logger.info(String.format("[%s] - " + text, this.prefix));
    }

    public void error(String text) {
        this.logger.severe(String.format("[%s] - " + text, this.prefix));
    }

    public void warn(String text) {
        this.logger.severe(String.format("[%s] - " + text, this.prefix));
    }
}

