/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.gui.builder;

import com.github.sanctum.labyrinth.gui.builder.ActionBuilder;
import com.github.sanctum.labyrinth.gui.builder.PaginatedBuilder;
import java.util.UUID;
import java.util.function.Supplier;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;

public class SyncMenuItemPreProcessEvent
extends Event {
    private static final HandlerList handlers = new HandlerList();
    private final String context;
    private ItemStack item;
    private final PaginatedBuilder builder;

    public SyncMenuItemPreProcessEvent(PaginatedBuilder builder, String context, ItemStack item) {
        this.builder = builder;
        this.context = context;
        this.item = item;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public UUID getId() {
        return this.builder.getId();
    }

    public ActionBuilder action() {
        return new ActionBuilder(this.item, this.builder);
    }

    public String getContext() {
        return this.context;
    }

    public void craftItem(String displayName) {
        ItemMeta meta = this.item.getItemMeta();
        UUID id = UUID.fromString(this.getContext());
        meta.setDisplayName(displayName);
        meta.getPersistentDataContainer().set(this.builder.getKey(), PersistentDataType.STRING, (Object)this.getContext());
        this.item.setItemMeta(meta);
    }

    public void buildItem(Supplier<ItemStack> itemStackSupplier) {
        this.item = itemStackSupplier.get();
    }
}

