/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.gui.builder;

import com.github.sanctum.labyrinth.gui.builder.PaginatedBuilder;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;

public class SyncMenuClickItemEvent
extends Event
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private final ItemStack item;
    private final InventoryView view;
    private final PaginatedBuilder builder;
    private final Player whoClicked;
    private boolean cancelled;

    public SyncMenuClickItemEvent(PaginatedBuilder builder, Player whoClicked, InventoryView view, ItemStack item) {
        this.builder = builder;
        this.whoClicked = whoClicked;
        this.view = view;
        this.item = item;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public UUID getId() {
        return this.builder.getId();
    }

    public Player getWhoClicked() {
        return this.whoClicked;
    }

    public InventoryView getView() {
        return this.view;
    }

    public void refresh() {
        this.builder.inv = Bukkit.createInventory(null, (int)54, (String)this.builder.title.replace("{PAGE}", "" + (this.builder.page + 1)).replace("{MAX}", "" + this.builder.getMaxPages()));
        this.whoClicked.openInventory(this.builder.adjust(this.builder.page).getInventory());
    }

    public void close() {
        this.whoClicked.closeInventory();
        HandlerList.unregisterAll((Listener)this.builder.listener);
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }
}

