/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.formatting.string;

import com.github.sanctum.labyrinth.library.StringUtils;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;

public class ColoredString {
    private final ColorType chosen;
    private final String text;
    private final String WITH_DELIMITER = "((?<=%1$s)|(?=%1$s))";

    public ColoredString(String text, ColorType type) {
        this.text = text;
        this.chosen = type;
    }

    public String toString() {
        String r = "No context to return";
        switch (this.chosen) {
            case MC: {
                r = ChatColor.translateAlternateColorCodes((char)'&', (String)this.text);
                break;
            }
            case MC_COMPONENT: {
                r = "Cannot convert raw component to String";
                break;
            }
            case HEX: {
                r = this.translateHexString(this.text);
            }
        }
        return r;
    }

    public TextComponent toComponent() {
        return Bukkit.getVersion().contains("1.16") ? this.translateHexComponent(this.text) : new TextComponent(StringUtils.translate(this.text));
    }

    private String translateHexString(String text) {
        String[] texts = text.split(String.format("((?<=%1$s)|(?=%1$s))", "&"));
        StringBuilder finalText = new StringBuilder();
        for (int i = 0; i < texts.length; ++i) {
            if (texts[i].equalsIgnoreCase("&")) {
                if (texts[++i].charAt(0) == '#') {
                    finalText.append(net.md_5.bungee.api.ChatColor.of((String)texts[i].substring(0, 7))).append(texts[i].substring(7));
                    continue;
                }
                finalText.append(net.md_5.bungee.api.ChatColor.translateAlternateColorCodes((char)'&', (String)("&" + texts[i])));
                continue;
            }
            finalText.append(texts[i]);
        }
        return finalText.toString();
    }

    private TextComponent translateHexComponent(String text) {
        String[] texts = text.split(String.format("((?<=%1$s)|(?=%1$s))", "&"));
        ComponentBuilder builder = new ComponentBuilder();
        for (int i = 0; i < texts.length; ++i) {
            TextComponent subComponent = new TextComponent();
            if (texts[i].equalsIgnoreCase("&")) {
                if (texts[++i].charAt(0) == '#') {
                    subComponent.setText(texts[i].substring(7));
                    subComponent.setColor(net.md_5.bungee.api.ChatColor.of((String)texts[i].substring(0, 7)));
                    builder.append((BaseComponent)subComponent);
                    continue;
                }
                builder.append(this.translateHexString("&" + texts[i]));
                continue;
            }
            builder.append(texts[i]);
        }
        return new TextComponent(builder.create());
    }

    public static enum ColorType {
        MC,
        MC_COMPONENT,
        HEX;

    }
}

