/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.labyrinth.command;

import com.github.sanctum.labyrinth.Labyrinth;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.plugin.Plugin;

public class CommandBuilder {
    Plugin plugin;

    public CommandBuilder(Plugin instance) {
        this.plugin = instance;
    }

    public void compileFields(String packageName) {
        HashSet classes = Sets.newHashSet();
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(URLDecoder.decode(this.plugin.getClass().getProtectionDomain().getCodeSource().getLocation().getFile(), "UTF-8"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (JarEntry jarEntry : Collections.list(jarFile.entries())) {
            Class<?> clazz;
            String className = jarEntry.getName().replace("/", ".");
            if (!className.startsWith(packageName) || !className.endsWith(".class")) continue;
            try {
                clazz = Class.forName(className.substring(0, className.length() - 6));
            }
            catch (ClassNotFoundException e) {
                Labyrinth.getInstance().getLogger().severe("- Unable to find class" + className + "! Double check package location. See the error below for more information.");
                e.printStackTrace();
                break;
            }
            if (!BukkitCommand.class.isAssignableFrom(clazz)) continue;
            classes.add(clazz);
        }
        for (Class aClass : classes) {
            try {
                BukkitCommand command = (BukkitCommand)aClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Field commandMapField = Bukkit.getServer().getClass().getDeclaredField("commandMap");
                commandMapField.setAccessible(true);
                CommandMap commandMap = (CommandMap)commandMapField.get(Bukkit.getServer());
                commandMap.register(command.getLabel(), this.plugin.getName(), (Command)command);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
                Labyrinth.getInstance().getLogger().severe("- Unable to cast BukkitCommand to the class " + aClass.getName() + ". This likely means you are not extending BukkitCommand for your command class.");
                e.printStackTrace();
                break;
            }
        }
    }
}

