/*
 * Decompiled with CFR 0.152.
 */
package com.github.testpress.mikephil.charting.renderer.scatter;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import com.github.testpress.mikephil.charting.buffer.ScatterBuffer;
import com.github.testpress.mikephil.charting.interfaces.datasets.IScatterDataSet;
import com.github.testpress.mikephil.charting.renderer.scatter.ShapeRenderer;
import com.github.testpress.mikephil.charting.utils.Utils;
import com.github.testpress.mikephil.charting.utils.ViewPortHandler;

public class TriangleShapeRenderer
implements ShapeRenderer {
    protected Path mTrianglePathBuffer = new Path();

    @Override
    public void renderShape(Canvas c, IScatterDataSet dataSet, ViewPortHandler viewPortHandler, ScatterBuffer buffer, Paint renderPaint, float shapeSize) {
        float shapeHalf = shapeSize / 2.0f;
        float shapeHoleSizeHalf = Utils.convertDpToPixel(dataSet.getScatterShapeHoleRadius());
        float shapeHoleSize = shapeHoleSizeHalf * 2.0f;
        float shapeStrokeSize = (shapeSize - shapeHoleSize) / 2.0f;
        int shapeHoleColor = dataSet.getScatterShapeHoleColor();
        renderPaint.setStyle(Paint.Style.FILL);
        Path tri = this.mTrianglePathBuffer;
        tri.reset();
        for (int i = 0; i < buffer.size() && viewPortHandler.isInBoundsRight(buffer.buffer[i]); i += 2) {
            if (!viewPortHandler.isInBoundsLeft(buffer.buffer[i]) || !viewPortHandler.isInBoundsY(buffer.buffer[i + 1])) continue;
            renderPaint.setColor(dataSet.getColor(i / 2));
            tri.moveTo(buffer.buffer[i], buffer.buffer[i + 1] - shapeHalf);
            tri.lineTo(buffer.buffer[i] + shapeHalf, buffer.buffer[i + 1] + shapeHalf);
            tri.lineTo(buffer.buffer[i] - shapeHalf, buffer.buffer[i + 1] + shapeHalf);
            if ((double)shapeSize > 0.0) {
                tri.lineTo(buffer.buffer[i], buffer.buffer[i + 1] - shapeHalf);
                tri.moveTo(buffer.buffer[i] - shapeHalf + shapeStrokeSize, buffer.buffer[i + 1] + shapeHalf - shapeStrokeSize);
                tri.lineTo(buffer.buffer[i] + shapeHalf - shapeStrokeSize, buffer.buffer[i + 1] + shapeHalf - shapeStrokeSize);
                tri.lineTo(buffer.buffer[i], buffer.buffer[i + 1] - shapeHalf + shapeStrokeSize);
                tri.lineTo(buffer.buffer[i] - shapeHalf + shapeStrokeSize, buffer.buffer[i + 1] + shapeHalf - shapeStrokeSize);
            }
            tri.close();
            c.drawPath(tri, renderPaint);
            tri.reset();
            if (!((double)shapeSize > 0.0) || shapeHoleColor == 0x112233) continue;
            renderPaint.setColor(shapeHoleColor);
            tri.moveTo(buffer.buffer[i], buffer.buffer[i + 1] - shapeHalf + shapeStrokeSize);
            tri.lineTo(buffer.buffer[i] + shapeHalf - shapeStrokeSize, buffer.buffer[i + 1] + shapeHalf - shapeStrokeSize);
            tri.lineTo(buffer.buffer[i] - shapeHalf + shapeStrokeSize, buffer.buffer[i + 1] + shapeHalf - shapeStrokeSize);
            tri.close();
            c.drawPath(tri, renderPaint);
            tri.reset();
        }
    }
}

