/*
 * Decompiled with CFR 0.152.
 */
package com.github.testpress.mikephil.charting.formatter;

import com.github.testpress.mikephil.charting.components.AxisBase;
import com.github.testpress.mikephil.charting.data.Entry;
import com.github.testpress.mikephil.charting.formatter.AxisValueFormatter;
import com.github.testpress.mikephil.charting.formatter.FormattedStringCache;
import com.github.testpress.mikephil.charting.formatter.ValueFormatter;
import com.github.testpress.mikephil.charting.utils.ViewPortHandler;
import java.text.DecimalFormat;

public class LargeValueFormatter
implements ValueFormatter,
AxisValueFormatter {
    private static String[] SUFFIX = new String[]{"", "k", "m", "b", "t"};
    private static final int MAX_LENGTH = 5;
    private String mText = "";
    protected FormattedStringCache.PrimDouble mFormattedStringCache = new FormattedStringCache.PrimDouble(new DecimalFormat("###E00"));

    public LargeValueFormatter() {
    }

    public LargeValueFormatter(String appendix) {
        this();
        this.mText = appendix;
    }

    @Override
    public String getFormattedValue(float value, Entry entry, int dataSetIndex, ViewPortHandler viewPortHandler) {
        return this.makePretty(value) + this.mText;
    }

    @Override
    public String getFormattedValue(float value, AxisBase axis) {
        return this.makePretty(value) + this.mText;
    }

    public void setAppendix(String appendix) {
        this.mText = appendix;
    }

    public void setSuffix(String[] suff) {
        SUFFIX = suff;
    }

    private String makePretty(double number) {
        String r = this.mFormattedStringCache.getFormattedValue(number);
        int numericValue1 = Character.getNumericValue(r.charAt(r.length() - 1));
        int numericValue2 = Character.getNumericValue(r.charAt(r.length() - 2));
        int combined = Integer.valueOf(numericValue2 + "" + numericValue1);
        r = r.replaceAll("E[0-9][0-9]", SUFFIX[combined / 3]);
        while (r.length() > 5 || r.matches("[0-9]+\\.[a-z]")) {
            r = r.substring(0, r.length() - 2) + r.substring(r.length() - 1);
        }
        return r;
    }

    @Override
    public int getDecimalDigits() {
        return 0;
    }
}

