/*
 * Decompiled with CFR 0.152.
 */
package com.github.testpress.mikephil.charting.data;

import android.annotation.TargetApi;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import com.github.testpress.mikephil.charting.data.Entry;
import com.github.testpress.mikephil.charting.data.LineScatterCandleRadarDataSet;
import com.github.testpress.mikephil.charting.interfaces.datasets.ILineRadarDataSet;
import com.github.testpress.mikephil.charting.utils.Utils;
import java.util.List;

public abstract class LineRadarDataSet<T extends Entry>
extends LineScatterCandleRadarDataSet<T>
implements ILineRadarDataSet<T> {
    private int mFillColor = Color.rgb((int)140, (int)234, (int)255);
    protected Drawable mFillDrawable;
    private int mFillAlpha = 85;
    private float mLineWidth = 2.5f;
    private boolean mDrawFilled = false;

    public LineRadarDataSet(List<T> yVals, String label) {
        super(yVals, label);
    }

    @Override
    public int getFillColor() {
        return this.mFillColor;
    }

    public void setFillColor(int color) {
        this.mFillColor = color;
        this.mFillDrawable = null;
    }

    @Override
    public Drawable getFillDrawable() {
        return this.mFillDrawable;
    }

    @TargetApi(value=18)
    public void setFillDrawable(Drawable drawable) {
        this.mFillDrawable = drawable;
    }

    @Override
    public int getFillAlpha() {
        return this.mFillAlpha;
    }

    public void setFillAlpha(int alpha) {
        this.mFillAlpha = alpha;
    }

    public void setLineWidth(float width) {
        if (width < 0.2f) {
            width = 0.2f;
        }
        if (width > 10.0f) {
            width = 10.0f;
        }
        this.mLineWidth = Utils.convertDpToPixel(width);
    }

    @Override
    public float getLineWidth() {
        return this.mLineWidth;
    }

    @Override
    public void setDrawFilled(boolean filled) {
        this.mDrawFilled = filled;
    }

    @Override
    public boolean isDrawFilledEnabled() {
        return this.mDrawFilled;
    }
}

