/*
 * Decompiled with CFR 0.152.
 */
package com.github.testpress.mikephil.charting.data;

import android.annotation.SuppressLint;
import com.github.testpress.mikephil.charting.data.Entry;

@SuppressLint(value={"ParcelCreator"})
public class CandleEntry
extends Entry {
    private float mShadowHigh = 0.0f;
    private float mShadowLow = 0.0f;
    private float mClose = 0.0f;
    private float mOpen = 0.0f;

    public CandleEntry(float x, float shadowH, float shadowL, float open, float close) {
        super(x, (shadowH + shadowL) / 2.0f);
        this.mShadowHigh = shadowH;
        this.mShadowLow = shadowL;
        this.mOpen = open;
        this.mClose = close;
    }

    public CandleEntry(float x, float shadowH, float shadowL, float open, float close, Object data) {
        super(x, (shadowH + shadowL) / 2.0f, data);
        this.mShadowHigh = shadowH;
        this.mShadowLow = shadowL;
        this.mOpen = open;
        this.mClose = close;
    }

    public float getShadowRange() {
        return Math.abs(this.mShadowHigh - this.mShadowLow);
    }

    public float getBodyRange() {
        return Math.abs(this.mOpen - this.mClose);
    }

    @Override
    public float getY() {
        return super.getY();
    }

    @Override
    public CandleEntry copy() {
        CandleEntry c = new CandleEntry(this.getX(), this.mShadowHigh, this.mShadowLow, this.mOpen, this.mClose, this.getData());
        return c;
    }

    public float getHigh() {
        return this.mShadowHigh;
    }

    public void setHigh(float mShadowHigh) {
        this.mShadowHigh = mShadowHigh;
    }

    public float getLow() {
        return this.mShadowLow;
    }

    public void setLow(float mShadowLow) {
        this.mShadowLow = mShadowLow;
    }

    public float getClose() {
        return this.mClose;
    }

    public void setClose(float mClose) {
        this.mClose = mClose;
    }

    public float getOpen() {
        return this.mOpen;
    }

    public void setOpen(float mOpen) {
        this.mOpen = mOpen;
    }
}

