/*
 * Decompiled with CFR 0.152.
 */
package com.github.testpress.mikephil.charting.jobs;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.view.View;
import com.github.testpress.mikephil.charting.jobs.ViewPortJob;
import com.github.testpress.mikephil.charting.utils.Transformer;
import com.github.testpress.mikephil.charting.utils.ViewPortHandler;

@SuppressLint(value={"NewApi"})
public abstract class AnimatedViewPortJob
extends ViewPortJob
implements ValueAnimator.AnimatorUpdateListener,
Animator.AnimatorListener {
    protected ObjectAnimator animator;
    protected float phase;
    protected float xOrigin;
    protected float yOrigin;

    public AnimatedViewPortJob(ViewPortHandler viewPortHandler, float xValue, float yValue, Transformer trans, View v, float xOrigin, float yOrigin, long duration) {
        super(viewPortHandler, xValue, yValue, trans, v);
        this.xOrigin = xOrigin;
        this.yOrigin = yOrigin;
        this.animator = ObjectAnimator.ofFloat((Object)this, (String)"phase", (float[])new float[]{0.0f, 1.0f});
        this.animator.setDuration(duration);
        this.animator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this);
        this.animator.addListener((Animator.AnimatorListener)this);
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public void run() {
        this.animator.start();
    }

    public float getPhase() {
        return this.phase;
    }

    public void setPhase(float phase) {
        this.phase = phase;
    }

    public float getXOrigin() {
        return this.xOrigin;
    }

    public float getYOrigin() {
        return this.yOrigin;
    }

    public abstract void recycleSelf();

    protected void resetAnimator() {
        this.animator.removeAllListeners();
        this.animator.removeAllUpdateListeners();
        this.animator.reverse();
        this.animator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this);
        this.animator.addListener((Animator.AnimatorListener)this);
    }

    public void onAnimationStart(Animator animation) {
    }

    public void onAnimationEnd(Animator animation) {
        try {
            this.recycleSelf();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void onAnimationCancel(Animator animation) {
        try {
            this.recycleSelf();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void onAnimationRepeat(Animator animation) {
    }

    public void onAnimationUpdate(ValueAnimator animation) {
    }
}

