/*
 * Decompiled with CFR 0.152.
 */
package com.github.testpress.mikephil.charting.formatter;

import com.github.testpress.mikephil.charting.data.Entry;
import com.github.testpress.mikephil.charting.formatter.FormattedStringCache;
import com.github.testpress.mikephil.charting.formatter.ValueFormatter;
import com.github.testpress.mikephil.charting.utils.ViewPortHandler;
import java.text.DecimalFormat;

public class DefaultValueFormatter
implements ValueFormatter {
    protected FormattedStringCache.Generic<Integer, Float> mFormattedStringCache;
    protected int mDecimalDigits;

    public DefaultValueFormatter(int digits) {
        this.setup(digits);
    }

    public void setup(int digits) {
        this.mDecimalDigits = digits;
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < digits; ++i) {
            if (i == 0) {
                b.append(".");
            }
            b.append("0");
        }
        this.mFormattedStringCache = new FormattedStringCache.Generic(new DecimalFormat("###,###,###,##0" + b.toString()));
    }

    @Override
    public String getFormattedValue(float value, Entry entry, int dataSetIndex, ViewPortHandler viewPortHandler) {
        return this.mFormattedStringCache.getFormattedValue(Float.valueOf(value), dataSetIndex);
    }

    public int getDecimalDigits() {
        return this.mDecimalDigits;
    }
}

